<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// DBSEO loader class

/**
* Loads configuration and handles other global things
*/
class DBSEO
{
	/**
	* Version info
	*
	* @public	mixed
	*/
	public static $version 			= '1.0.0';
	public static $versionnumber	= '100';
	
	/**
	* Whether we have the pro version or not
	*
	* @public	boolean
	*/		
	public static $isPro			= false;

	/**
	* Array of configuration items
	*
	* @public	array
	*/
	public static $config			= array();

	/**
	* Array of products
	*
	* @public	array
	*/
	public static $products			= array();

	/**
	* Array of configuration items
	*
	* @public	array
	*/
	public static $configFile		= array();

	/**
	* Array of cached items
	*
	* @public	array
	*/
	public static $cache			= array();
	
	/**
	* Whether we've called the DM fetcher
	*
	* @public	boolean
	*/		
	protected static $called		= false;

	/**
	* The database object
	*
	* @public	array
	*/
	public static $db				= NULL;

	/**
	* The datastore object
	*
	* @public	DBSEO_Datastore
	*/
	public static $datastore		= NULL;

	/**
	* The translation table
	*
	* @public	array
	*/
	public static $translationTable	= NULL;

	/**
	* Array of library items
	*
	* @public	array
	*/
	public static $libraries 		= array(
		'Forum' => array(
			'Forum' 							=> array('strict' => false, 'subsetting' => '', 			'priority' => 1030),
			'Forum_Page' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 1020),
		),
		'Announcement' => array(
			'Announcement' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 1000),
			'Announcement_Multiple' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 1010),
		),
		'Thread' => array(
			'Thread' 							=> array('strict' => false, 'subsetting' => '', 			'priority' => 990),
			'Thread_Page' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 980),
			'Thread_LastPost' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 530),
			'Thread_NewPost' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 499),
			'Thread_GoToPost' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 498),
			'Thread_GoToPost_Page' 				=> array('strict' => false, 'subsetting' => '', 			'priority' => 499),
			'Thread_Previous' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 570),
			'Thread_Next' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 560),
			'PrintThread' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 970),
			'PrintThread_Page' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 960),
		),
		'ShowPost' => array(
			'ShowPost' 							=> array('strict' => false, 'subsetting' => '', 			'priority' => 510),
		),
		'Poll' => array(
			'Poll' 								=> array('strict' => false, 'subsetting' => '', 			'priority' => 490),
		),
		'MemberList' => array(
			'MemberList' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 590),
			'MemberList_Page' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 580),
			'MemberList_Letter' 				=> array('strict' => false, 'subsetting' => '', 			'priority' => 600),
		),
		'Avatar' => array(
			'Avatar' 							=> array('strict' => false, 'subsetting' => '', 			'priority' => 1099),
		),
		'NavBullet' => array(
			'NavBullet_Forum' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => -1),
			'NavBullet_Thread' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => -1),
		),
		'Attachment' => array(
			'Attachment' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 1100),
			'Attachment_Alt' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => -1),
			'BlogAttachment' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 1110),
			'CMSAttachments' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 1120),
		),
		'Tags' => array(
			'TagList' 							=> array('strict' => true, 'subsetting' => '', 				'priority' => 800),
			'Tag_Single' 						=> array('strict' => true, 'subsetting' => '', 				'priority' => 790),
			'Tag_Single_Page' 					=> array('strict' => true, 'subsetting' => '',				'priority' => 780),
		),
		'CMS' => array(
			'CMSHome' 							=> array('strict' => true, 'subsetting' => '', 				'priority' => 420),
			'CMSSection' 						=> array('strict' => true, 'subsetting' => '', 				'priority' => 480),
			'CMSSection_List' 					=> array('strict' => true, 'subsetting' => '', 				'priority' => 460),
			'CMSSection_List_Page' 				=> array('strict' => true, 'subsetting' => '', 				'priority' => 470),
			'CMSCategory' 						=> array('strict' => true, 'subsetting' => '', 				'priority' => 440),
			'CMSCategory_Page' 					=> array('strict' => true, 'subsetting' => '', 				'priority' => 430),
			'CMSAuthor' 						=> array('strict' => true, 'subsetting' => '', 				'priority' => 460),
			'CMSAuthor_Page' 					=> array('strict' => true, 'subsetting' => '', 				'priority' => 450),
			'CMSEntry' 							=> array('strict' => true, 'subsetting' => '', 				'priority' => 410),
			'CMSEntry_Page' 					=> array('strict' => true, 'subsetting' => '', 				'priority' => 400),
			'CMSComments_Page' 					=> array('strict' => true, 'subsetting' => '', 				'priority' => 380),
		),
		'Blog' => array(
			'Blog' 								=> array('strict' => false, 'subsetting' => '', 			'priority' => 300),
			'Blog_Page' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 290),
			'Blogs' 							=> array('strict' => false, 'subsetting' => '', 			'priority' => 90),
			'BlogEntry' 						=> array('strict' => false, 'subsetting' => 'entry', 		'priority' => 10),
			'BlogEntry_Page' 					=> array('strict' => false, 'subsetting' => 'entry', 		'priority' => 80),
			'BlogComment' 						=> array('strict' => false, 'subsetting' => 'entry', 		'priority' => 117),
			'NextBlogEntry' 					=> array('strict' => false, 'subsetting' => 'entry', 		'priority' => 128),
			'PrevBlogEntry' 					=> array('strict' => false, 'subsetting' => 'entry', 		'priority' => 129),
			'BlogGlobalCategory' 				=> array('strict' => false, 'subsetting' => 'category', 	'priority' => 110),
			'BlogGlobalCategory_Page' 			=> array('strict' => false, 'subsetting' => 'category', 	'priority' => 100),
			'BlogCategory' 						=> array('strict' => false, 'subsetting' => 'category', 	'priority' => 130),
			'BlogCategory_Page' 				=> array('strict' => false, 'subsetting' => 'category', 	'priority' => 120),
			'BlogsByDay_Global' 				=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 60),
			'BlogsByDay_Global_Page' 			=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 50),
			'BlogsByMonth_Global' 				=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 40),
			'BlogsByMonth_Global_Page' 			=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 30),
			'AllBlogs' 							=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 00),
			'AllBlogs_Page' 					=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 190),
			'RecentBlogEntries' 				=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 118),
			'RecentBlogEntries_Page' 			=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 119),
			'LatestBlogEntries' 				=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 60),
			'LatestBlogEntries_Page' 			=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 50),
			'BestBlogEntries' 					=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 350),
			'BestBlogEntries_Page' 				=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 340),
			'BestBlogs' 						=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 330),
			'BestBlogs_Page' 					=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 320),
			'BlogComments' 						=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 360),
			'BlogComments_Page' 				=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 370),
			'BlogsByDay_User' 					=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 270),
			'BlogsByMonth_User' 				=> array('strict' => false, 'subsetting' => 'list', 		'priority' => 280),
			'CustomBlog' 						=> array('strict' => false, 'subsetting' => 'custom', 		'priority' => 70),
			'BlogFeedUser' 						=> array('strict' => false, 'subsetting' => 'feed', 		'priority' => 140),
			'BlogFeedGlobal' 					=> array('strict' => false, 'subsetting' => 'feed', 		'priority' => 150),
			'BlogTags' 							=> array('strict' => false, 'subsetting' => 'tag', 			'priority' => 40),
			'BlogTag' 							=> array('strict' => false, 'subsetting' => 'tag', 			'priority' => 30),
			'BlogTag_Page' 						=> array('strict' => false, 'subsetting' => 'tag', 			'priority' => 20),
		),
		'SocialGroup' => array(
			'SocialGroup' 						=> array('strict' => false, 'subsetting' => '', 			'priority' => 760),
			'SocialGroup_Page' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 750),
			'SocialGroupDiscussion' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 660),
			'SocialGroupDiscussion_Page' 		=> array('strict' => false, 'subsetting' => '', 			'priority' => 650),
			'SocialGroupDiscussion_LastPost' 	=> array('strict' => false, 'subsetting' => '', 			'priority' => 655),
			'SocialGroupList' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 610),
			'SocialGroupList_Page' 				=> array('strict' => false, 'subsetting' => '', 			'priority' => 620),
			'SocialGroupMembers' 				=> array('strict' => false, 'subsetting' => '', 			'priority' => 680),
			'SocialGroupMembers_Page' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 670),
			'SocialGroupPictures' 				=> array('strict' => false, 'subsetting' => '', 			'priority' => 700),
			'SocialGroupPictures_Page' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 690),
			'SocialGroupPicture' 				=> array('strict' => false, 'subsetting' => '', 			'priority' => 720),
			'SocialGroupPicture_Page' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 710),
			'SocialGroupCategoryList' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 640),
			'SocialGroupCategoryList_Page' 		=> array('strict' => false, 'subsetting' => '', 			'priority' => 630),
			'SocialGroupCategory' 				=> array('strict' => false, 'subsetting' => '', 			'priority' => 750),
			'SocialGroupCategory_Page' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 740),
			'SocialGroupHome' 					=> array('strict' => false, 'subsetting' => '', 			'priority' => 770),
			'SocialGroupPictureFile' 			=> array('strict' => false, 'subsetting' => '', 			'priority' => 730),
		),
		'MemberProfile' => array(
			'MemberProfile' 					=> array('strict' => true, 'subsetting' => '', 			'priority' => 940),
			'VisitorMessage_Page' 				=> array('strict' => true, 'subsetting' => '', 			'priority' => 930),
			'VisitorMessage_Conversation' 		=> array('strict' => true, 'subsetting' => '', 			'priority' => 920),
			'VisitorMessage_Conversation_Page' 	=> array('strict' => true, 'subsetting' => '', 			'priority' => 910),
			'FriendsList_Page' 					=> array('strict' => true, 'subsetting' => '', 			'priority' => 900),
		),
		'Album' => array(
			'Album' 							=> array('strict' => true, 'subsetting' => '', 			'priority' => 890),
			'Album_Page' 						=> array('strict' => true, 'subsetting' => '', 			'priority' => 880),
			'AlbumList' 						=> array('strict' => true, 'subsetting' => '', 			'priority' => 860),
			'AlbumList_Page' 					=> array('strict' => true, 'subsetting' => '', 			'priority' => 870),
			'AlbumPicture' 						=> array('strict' => true, 'subsetting' => '', 			'priority' => 820),
			'AlbumPicture_Page' 				=> array('strict' => true, 'subsetting' => '', 			'priority' => 810),
			'MemberAlbums' 						=> array('strict' => true, 'subsetting' => '', 			'priority' => 850),
			'MemberAlbums_Page' 				=> array('strict' => true, 'subsetting' => '', 			'priority' => 840),
			'AlbumPictureFile' 					=> array('strict' => true, 'subsetting' => '', 			'priority' => 830),
		),
	);

	public static $suggestedUrls = array();

	/**
	* Does important checking before anything else should be going on
	*/
	public static function init($lateInit = false)
	{
		if (count(self::$config))
		{
			// Already init'd
			return true;
		}

		if (!defined('DBSEO_CWD'))
		{
			// Define it based on what we can use
			define('DBSEO_CWD', (defined('DIR') ? DIR : '.'));
		}

		/*DBTECH_PRO_START*/
		// Set pro version
		self::$isPro = true;
		/*DBTECH_PRO_END*/

		// parse the config file
		$config = array();
		include(DBSEO_CWD . '/includes/config.php');

		if (sizeof($config) == 0)
		{
			if (file_exists(DBSEO_CWD . '/includes/config.php'))
			{
				// config.php exists, but does not define $config
				die('<br /><br /><strong>Configuration</strong>: includes/config.php exists, but is not in the 3.6+ format. Please convert your config file via the new config.php.new.');
			}
			else
			{
				die('<br /><br /><strong>Configuration</strong>: includes/config.php does not exist. Please fill out the data in config.php.new and rename it to config.php');
			}
		}

		// Set config file settings
		self::$configFile = $config;

		// We need our datastore
		$datastore_class = (!empty(self::$configFile['Datastore']['class'])) 			? str_replace('vB_', 'DBSEO_' , self::$configFile['Datastore']['class']) 	: 'DBSEO_Datastore';
		$datastore_class = (!empty(self::$configFile['Datastore']['dbseooverride'])) 	? 'DBSEO_Datastore' 														: $datastore_class;
		
		// Grab our datastore file
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/class_datastore.php');
		
		// Set the datastore
		self::$datastore = new $datastore_class();

		// We need our DB class
		include(DBSEO_CWD . '/dbtech/dbseo/includes/class_db.php');

		// Beware of assumption that it's only needed here
		self::$db = new DBSEO_Database($config);

		// Grab our settings
		self::$config = self::$db->fetchSettings();

		// Grab our products
		self::$products = self::$db->fetchProducts();

		if (!self::$products['vbblog'])
		{
			foreach (array(
				'blog',
				'blogattachment',
				'blogentry',
				'bloglist',
				'blogtag',
				'blogcustom',
				'blogcategory',
				'blogfeed'
			) as $setting)
			{
				// Product didn't exist
				self::$config['dbtech_dbseo_rewrite_' . $setting] = false;
			}
		}

		if (!self::$products['vbcms'])
		{
			foreach (array(
				'cms',
			) as $setting)
			{
				// Product didn't exist
				self::$config['dbtech_dbseo_rewrite_' . $setting] = false;
			}
		}

		// Set our cookie prefix
		self::$config['_cookieprefix'] = $config['Misc']['cookieprefix'];

		if (intval(self::$config['templateversion']) == 4)
		{
			// vB4 added this little underscore for the lulz
			self::$config['_cookieprefix'] .= '_';
		}

		// Check whether we can strip the session hash safely
		self::$config['_stripsessionhash'] = isset($_COOKIE[self::$config['_cookieprefix'] . 'sessionhash']) OR (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === false AND ($_SERVER['HTTP_REFERER'] OR !$_GET['s']));

		if (intval(self::$config['templateversion']) == 4)
		{
			// Add some extra config options
			self::$config['_picturescript'] 	= 'attachment';
			self::$config['_picturestorage'] 	= 'attach';
			self::$config['_pictureid'] 		= 'attachmentid';
			self::$config['_blogattach'] 		= self::$config['_picturescript'];
			self::$config['_blogentry'] 		= 'entry';
		}
		else
		{
			// vB3 stuff
			self::$config['_picturescript'] 	= 'picture';
			self::$config['_picturestorage'] 	= 'pic';
			self::$config['_pictureid'] 		= 'pictureid';
			self::$config['_blogattach'] 		= 'blog_attachment';
			self::$config['_blogentry'] 		= 'blog';
		}

		// Shorthand the config option for forum home
		$homePage = isset(self::$config['forumhome']) ? self::$config['forumhome'] . '.php' : '';

		if ($homePage == 'index.php' AND self::$config['dbtech_dbseo_force_directory_index'])
		{
			// We're forcibly removing index.php to boost PR
			$homePage = '';
		}

		// Ensure this is the correct format
		self::$config['dbtech_dbseo_stopwordlist'] = str_replace(array("\r\n", "\r", "\n"), '|', self::$config['dbtech_dbseo_stopwordlist']);

		// Now set this, we'll need it
		self::$config['dbtech_dbseo_socialshare_usergroups'] = @unserialize(self::$config['dbtech_dbseo_socialshare_usergroups']);
		self::$config['dbtech_dbseo_socialshare_usergroups'] = is_array(self::$config['dbtech_dbseo_socialshare_usergroups']) ? self::$config['dbtech_dbseo_socialshare_usergroups'] : array();

		if (isset(self::$config['dbtech_dbseo_socialshare_usergroups']) AND !self::$config['dbtech_dbseo_socialshare_usergroups'][0])
		{
			// We don't want this
			unset(self::$config['dbtech_dbseo_socialshare_usergroups'][0]);
		}

		// Now set this, we'll need it
		self::$config['_homepage'] = $homePage;

		// Get server port
		$port = intval($_SERVER['SERVER_PORT']);
		$port = in_array($port, array(80, 443)) ? '' : ':' . $port;

		// resolve the request scheme
		$scheme = ((':443' == $port) OR (isset($_SERVER['HTTPS']) AND $_SERVER['HTTPS'] AND ($_SERVER['HTTPS'] != 'off'))) ? 'https://' : 'http://';

		if ($scheme == 'http://' AND $_SERVER['SERVER_PORT'] == 443)
		{
			$port = ':443';
		}

		$host = self::fetchServerValue('HTTP_HOST');
		$name = self::fetchServerValue('SERVER_NAME');

		// If host exists use it, otherwise fallback to servername.
		$host = (!empty($host) ? $host : $name);

		// resolve the query
		$query = ($query = self::fetchServerValue('QUERY_STRING')) ? '?' . $query : '';
		$query = self::urlencodeQuery($query);

		// resolve the path and query
		if (!($scriptpath = self::fetchServerValue('REQUEST_URI')))
		{
			if (!($scriptpath = self::fetchServerValue('UNENCODED_URL')))
			{
				$scriptpath = self::fetchServerValue('HTTP_X_REWRITE_URL');
			}
		}

		if (strpos($scriptpath, 'vbseo.php') !== false AND $_GET['vbseourl'])
		{
			// This is for compatibility reasons only
			$scriptpath = preg_replace('#vbseo\.php.*#', $_GET['vbseourl'], $scriptpath);
		}

		if (strpos($scriptpath, 'dbseo.php') !== false AND $_GET['dbseourl'])
		{
			// For DBSEO
			$scriptpath = preg_replace('#dbseo\.php.*#', $_GET['dbseourl'], $scriptpath);
		}

		// Get rid of page links
		$scriptpath = preg_replace('/#.*$/', '', $scriptpath);

		// Set the new script path in the REQUEST_URI, preserving the query (if any)
		$_SERVER['REQUEST_URI'] = $scriptpath;

		if ($scriptpath)
		{
			$scriptpath = self::urlencodeQuery($scriptpath);
			$query = '';
		}
		else
		{
			// server hasn't provided a URI, try to resolve one
			if (!$scriptpath = self::fetchServerValue('PATH_INFO'))
			{
				if (!$scriptpath = self::fetchServerValue('REDIRECT_URL'))
				{
					if (!($scriptpath = self::fetchServerValue('URL')))
					{
						if (!($scriptpath = self::fetchServerValue('PHP_SELF')))
						{
							$scriptpath = self::fetchServerValue('SCRIPT_NAME');
						}
					}
				}
			}
		}

		// build the URL
		$url = $scheme . $host . '/' . ltrim($scriptpath, '/\\') . $query;

		// store a literal version
		define('DBSEO_URL', $url);

		// check relative path
		if (defined('DBSEO_RELATIVE_PATH'))
		{
			define('DBSEO_URL_RELATIVE_PATH', trim(DBSEO_RELATIVE_PATH, '/') . '/');
		}
		else
		{
			define('DBSEO_URL_RELATIVE_PATH', '');
		}

		// Set URL info
		$url_info = self::parseUrl(DBSEO_URL);
		$url_info['path'] = '/' . ltrim($url_info['path'], '/\\');
		$url_info['query_raw'] = (isset($url_info['query']) ? $url_info['query'] : '');
		$url_info['query'] = self::stripSessionhash($url_info['query']);
		$url_info['query'] = trim($url_info['query'], '?&') ? $url_info['query'] : '';

		/*
			values seen in the wild:

			CGI+suexec:
			SCRIPT_NAME: /vb4/admincp/index.php
			ORIG_SCRIPT_NAME: /cgi-sys/php53-fcgi-starter.fcgi

			CGI #1:
			SCRIPT_NAME: /index.php
			ORIG_SCRIPT_NAME: /search/foo

			CGI #2:
			SCRIPT_NAME: /index.php/search/foo
			ORIG_SCRIPT_NAME: /index.php

		*/

		if (substr(PHP_SAPI, -3) == 'cgi' AND (isset($_SERVER['ORIG_SCRIPT_NAME']) AND !empty($_SERVER['ORIG_SCRIPT_NAME'])))
		{
			if (substr($_SERVER['SCRIPT_NAME'], 0, strlen($_SERVER['ORIG_SCRIPT_NAME'])) == $_SERVER['ORIG_SCRIPT_NAME'])
			{
				// cgi #2 above
				$url_info['script'] = $_SERVER['ORIG_SCRIPT_NAME'];
			}
			else
			{
				// cgi #1 and CGI+suexec above
				$url_info['script'] = $_SERVER['SCRIPT_NAME'];
			}
		}
		else
		{
			$url_info['script'] = (isset($_SERVER['ORIG_SCRIPT_NAME']) AND !empty($_SERVER['ORIG_SCRIPT_NAME'])) ? $_SERVER['ORIG_SCRIPT_NAME'] : $_SERVER['SCRIPT_NAME'];
		}
		$url_info['script'] = '/' . ltrim($url_info['script'], '/\\');

		// define constants
		define('DBSEO_URL_SCHEME',      $url_info['scheme']);
		define('DBSEO_URL_HOST',        $url_info['host']);
		define('DBSEO_URL_PORT',        $port);
		define('DBSEO_URL_SCRIPT_PATH', rtrim(dirname($url_info['script']), '/\\') . '/');
		define('DBSEO_URL_SCRIPT',      basename($url_info['script']));
		define('DBSEO_URL_PATH',        urldecode($url_info['path']));
		define('DBSEO_URL_PATH_RAW',    $url_info['path']);
		define('DBSEO_URL_QUERY',       $url_info['query'] ? $url_info['query'] : '');
		define('DBSEO_URL_QUERY_RAW',   $url_info['query_raw']);
		define('DBSEO_URL_CLEAN',       self::xssClean(self::stripSessionhash(DBSEO_URL)));
		define('DBSEO_URL_WEBROOT',     self::xssClean(DBSEO_URL_SCHEME . '://' . DBSEO_URL_HOST . DBSEO_URL_PORT));
		define('DBSEO_URL_BASE_PATH',   self::xssClean(DBSEO_URL_SCHEME . '://' . DBSEO_URL_HOST . DBSEO_URL_PORT . DBSEO_URL_SCRIPT_PATH . DBSEO_URL_RELATIVE_PATH));

		// legacy constants
		define('DBSEO_SCRIPT',       	$_SERVER['SCRIPT_NAME']);
		define('DBSEO_SCRIPTPATH',   	self::xssClean(self::addQuery(DBSEO_URL_PATH)));
		define('DBSEO_REQ_PROTOCOL', 	$url_info['scheme']);
		define('DBSEO_HTTP_HOST', 		DBSEO_URL_HOST . DBSEO_URL_PORT);

		// Ported constants
		define('DBSEO_BASE',   			preg_replace('#[^/]*$#', '', DBSEO_URL_PATH_RAW));
		define('DBSEO_BASEDEPTH', 		
			stripos((strlen(DBSEO_URL_SCRIPT_PATH) < strlen(DBSEO_BASE) AND stripos(DBSEO_BASE, DBSEO_URL_SCRIPT_PATH) !== false) ? substr(DBSEO_BASE, strlen(DBSEO_URL_SCRIPT_PATH)) : '', '/') !== false OR 
			(strlen(DBSEO_URL_SCRIPT_PATH) > strlen(DBSEO_BASE)) OR stripos(DBSEO_BASE, DBSEO_URL_SCRIPT_PATH) === false
		);
		define('DBSEO_REQURL', 			substr(DBSEO_SCRIPTPATH, strlen(DBSEO_URL_SCRIPT_PATH)));
		define('DBSEO_REQURL2', 		substr(DBSEO_URL_PATH_RAW, strlen(DBSEO_URL_SCRIPT_PATH)));

		$_fileFromQuery = $_relpath = '';
		if (isset($_GET['vbseourl']) OR isset($_GET['dbseourl']))
		{
			// We have it in the GET param
			$_fileFromQuery = isset($_GET['vbseourl']) ? $_GET['vbseourl'] : $_GET['dbseourl'];
		}
		else
		{
			// It came from the query
			$_fileFromQuery = DBSEO_REQURL2;
		}

		if (@ini_get('magic_quotes_gpc'))
		{
			// This is deprecated so it's of limited use
			$_fileFromQuery = stripslashes($_fileFromQuery);
		}

		// Get rid of chars we don't want
		list($_fileFromQuery, $_relpath) = preg_replace('#[\x00-\x1F]#', '', array($_fileFromQuery, $_relpath));

		if (preg_match('#^(.*?\.php)/(.*)$#', $_fileFromQuery, $matches) AND file_exists($matches[1]))
		{
			// We're pointing to a PHP file
			$_fileFromQuery = $matches[1];
		}		
		
		if ((isset($_GET['vbseorelpath']) OR isset($_GET['dbseorelpath'])) AND ($_GET['vbseourl'] OR $_GET['dbseourl']))
		{
			// We had a relpath in the URL
			$_relpath = isset($_GET['vbseorelpath']) ? $_GET['vbseorelpath'] : $_GET['dbseorelpath'];
		}

		$_redirUrl = self::addQuery($_SERVER['REDIRECT_URL'], $url_info['query'] ? $url_info['query'] : '');
		if (strpos($_redirUrl, '/dbseo.php') !== false)
		{
			$_redirUrl = '';
		}
		else if (strpos($_SERVER['PHP_SELF'], '/dbseo.php') !== false)
		{
			$_SERVER['PHP_SELF'] = $_SERVER['SCRIPT_NAME'] = $_SERVER['REDIRECT_URL'];
		}

		if (substr_count(DBSEO_URL_SCRIPT_PATH, '/') <= substr_count($_relpath, '..'))
		{
			// We had directory navigations we need to filter out
			$_relpath = '';
		}
		
		if ($_relpath AND !file_exists($_relpath))
		{
			// The file didn't exist, blank out the path
			$_relpath = '';
		}

		define('DBSEO_URL_QUERY_FILE', 	$_fileFromQuery);
		define('DBSEO_BASEURL',			basename($_fileFromQuery));
		define('DBSEO_RELPATH', 		$_relpath);
		define('DBSEO_REDIRURL', 		substr($_redirUrl, stristr(DBSEO_BASE, DBSEO_URL_SCRIPT_PATH) ? min(strlen(DBSEO_BASE), strlen(DBSEO_URL_SCRIPT_PATH)) : strlen(DBSEO_BASE)));

		// Set the backup bburl
		self::$config['_bburl'] = str_replace('http://', DBSEO_URL_SCHEME . '://', preg_replace('#/+$#', '', self::$config['bburl']));

		$parser = xml_parser_create();
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($parser, file_get_contents(DBSEO_CWD . '/includes/xml/spiders_dbtech_dbseo.xml'), $vals, $index);
		xml_parser_free($parser);

		$spiders = array();
		foreach ($vals as $tagInfo)
		{
			if ($tagInfo['tag'] != 'spider' OR $tagInfo['type'] != 'open' OR !isset($tagInfo['attributes']['ident']))
			{
				// Skip this
				continue;
			}

			// Store the spider
			$spiders[] = preg_quote($tagInfo['attributes']['ident'], '#');
		}

		// Match spider list
		preg_match('#(' . implode('|', $spiders) . ')#i', $_SERVER['HTTP_USER_AGENT'], $matches);

		// We're a spider
		define('DBSEO_SPIDER', $matches[1]);
		//define('DBSEO_SPIDER', 'belazorbot');

		$excludedPages = preg_split('#\r?\n#s', self::$config['dbtech_dbseo_excludedpages'], -1, PREG_SPLIT_NO_EMPTY);
		foreach ($excludedPages as &$excludedPage)
		{
			// Ensure this is quoted properly
			$excludedPage = preg_quote($excludedPage, '#');
		}

		if (self::$config['dbtech_dbseo_active'])
		{
			// Check for excluded pages
			$excludedPages = implode('|', $excludedPages);

			// Mod was active, check if it should remain that way
			self::$config['dbtech_dbseo_active'] = !($excludedPages AND (
				preg_match('#(' . $excludedPages . ')#i', DBSEO_REQURL) OR
				preg_match('#(' . $excludedPages . ')#i', DBSEO_BASE) OR
				preg_match('#(' . $excludedPages . ')#i', DBSEO_HTTP_HOST)
			));
		}

		if (self::$config['dbtech_dbseo_notfound_chooser'] == 2)
		{
			// Fix relative paths
			self::$config['dbtech_dbseo_notfound_custom'] = (substr(self::$config['dbtech_dbseo_notfound_custom'], 0, 1) != '/') ? DBSEO_CWD . '/' . self::$config['dbtech_dbseo_notfound_custom'] : self::$config['dbtech_dbseo_notfound_custom'];

			if (!file_exists(self::$config['dbtech_dbseo_notfound_custom']))
			{
				// Revert to 404
				self::$config['dbtech_dbseo_notfound_chooser'] = 1;
			}
		}

		// Normal icons
		$d = dir(DBSEO_CWD . '/dbtech/dbseo/includes/addons/library');
		while (false !== ($file = $d->read()))
		{
			if (!in_array($file, array('.', '..', 'index.html', 'library')) AND pathinfo($file, PATHINFO_EXTENSION) == 'php')
			{
				// Grab our config file
				require_once(DBSEO_CWD . '/dbtech/dbseo/includes/addons/library/' . $file);
			}

		}
		$d->close();

		$isPro = false;
		/*DBTECH_PRO_START*/
		$isPro = true;
		/*DBTECH_PRO_END*/
		if ($_REQUEST['do'] == 'devinfo' AND $_REQUEST['devkey'] == 'dbtech')
		{
			die('{"version":"' . self::$version . '","pro":"' . ($isPro ? 'true' : 'false') . '","vbversion":"N/A"}');
		}
	}

	/**
	 * Validates that we aren't trying to do anything funky in the URL
	 *
	 * @param string $uri
	 * @return boolean
	 */
	public static function securityCheck($uri)
	{
		if (substr($uri, 0, 1) == '/')
		{
			// We can't have the first char being a / now can we.
			return false;
		}

		if (substr($uri, 0, 3) == '../')
		{
			// No directory navigation, thanks
			return false;
		}
		
		if (strpos(DBSEO_REQURL, 'vbseourl=') !== false)
		{
			// COMPATIBILITY: This cannot exist here
			return false;
		}
		
		if (strpos(DBSEO_REQURL, 'dbseourl=') !== false)
		{
			// COMPATIBILITY: This cannot exist here
			return false;
		}

		foreach (array(
			'/../',
			'://',
			'<script',
		) as $key)
		{
			if (strpos($uri, $key) !== false)
			{
				// These cannot exist here
				return false;
			}

			if (strpos(urldecode($uri), $key) !== false)
			{
				// These cannot exist here
				return false;
			}
		}

		return true;
	}

	/**
	 * Changes the directory, with some additional checks
	 *
	 * @param string $dirname
	 */
	public static function changeDir($dirname)
	{
		// Shorthand
		$cwd = getcwd();
		$_fulldir = $cwd . '/' . $dirname;

		if (
			substr($dirname, 0, 1) == '/' OR 
			strpos($dirname, './../') !== false OR (
				is_writable($_fulldir) AND 
				!is_writable($cwd) AND 
				(fileperms($_fulldir) & 0755) != 0755
			)
		)
		{
			// Nope, not allowed here
			self::handle404('', true);
		}

		// If we got this far we're sorted
		@chdir($_fulldir);
	}

	/**
	 * Handles whatever event necessitates a 404 page
	 *
	 * @param string $uri
	 * @param boolean $force404
	 * 
	 * @return boolean
	 */
	public static function handle404($uri = '', $force404 = false)
	{
		if ($force404)
		{
			// Localise this variable so we can override it
			$_configSetting = 1;
		}
		else if ($uri)
		{
			// Localise this variable so we can override it
			$_configSetting = (preg_match('#\.(jpg|gif|png|js|css)$#', $uri) AND !self::$config['dbtech_dbseo_notfound_chooser']) ? 1 : self::$config['dbtech_dbseo_notfound_chooser'];
		}
		else
		{
			// Localise this variable so we can override it
			$_configSetting = self::$config['dbtech_dbseo_notfound_chooser'];
		}

		// Function can't handle the include, so let's just not try
		$_configSetting = $_configSetting == 2 ? 1 : $_configSetting;

		switch ($_configSetting)
		{
			case 1:
				header("HTTP/1.1 404 Not Found");
				//header("Status: 404 Not Found");
				die('Page not found');
				break;

			default:
				header("HTTP/1.1 301 Moved Permanently");
				header("Location: " . DBSEO_URL_SCRIPT_PATH . self::$config['forumhome'] . '.php');
				break;
		}
	}
	/**
	 * Reverses filtering to the username in question
	 *
	 * @param string $uri
	 * @param boolean $force404
	 * 
	 * @return boolean
	 */
	public static function reverseUsername($username)
	{
		if (($userId = self::$datastore->fetch('username.' . crc32($username))) === false)
		{
			// Test if we have a direct username match
			if (!$userInfo = self::$db->generalQuery('
				SELECT userid 
				FROM $user 
				WHERE username LIKE "' . str_replace(array('%', '_', self::$config['dbtech_dbseo_rewrite_separator']), array('\%' , '\_', ' '), $username) . '"
				LIMIT 1
			'))
			{
				// nooooope, try regexp
				$userInfo = self::$db->generalQuery('
					SELECT userid 
					FROM $user 
					WHERE username REGEXP "' . preg_quote(self::unFilterText(htmlspecialchars($username))) . '" 
					LIMIT 1
				');
			}

			// Store this
			$userId = $userInfo['userid'];

			// Build the cache
			self::$datastore->build('username.' . crc32($username), $userId);			
		}

		return $userId;
	}

	/**
	 * Looks up forum ID based on forum info
	 *
	 * @param array $info
	 * 
	 * @return integer
	 */
	public static function reverseForumTitle($info)
	{
		// Prepare fallback value
		$forumid = 0;

		// Grab our forum cache
		$forumcache = self::$db->fetchForumCache();

		if (isset($info['forum_path']))
		{
			foreach ($forumcache as $forum)
			{
				if ($forum['path'] == $info['forum_path'])
				{
					// We got our forum ID
					$forumid = $forum['forumid'];
					break;
				}
			}
		}
		else if (isset($info['forum_title']) AND is_array($forumcache))
		{
			$ue_title = urlencode($info['forum_title']);

			foreach ($forumcache as $forum)
			{
				// Set the SEO'd forum URL in the global cache
				self::rewriteForumUrl($forum);

				if (
					self::$db->cache['forumcache'][$forum['forumid']]['seotitle'] == $encodedTitle OR 
					self::$db->cache['forumcache'][$forum['forumid']]['seotitle'] == $info['forum_title']
				)
				{
					// We found our forum ID
					$forumid = $forum['forumid'];
					break;
				}
			}
		}

		return $forumid;
	}


	/**
	 * Reverses filtering to the text in question
	 *
	 * @param string $uri
	 * @param boolean $force404
	 * 
	 * @return boolean
	 */
	public static function reverseObject($object, $title, $id = 0)
	{
		$whereCond = $idColumn = $tableName = $title2 = $title3 = '';
		$appendTitle = false;
		$unfilterTitle = true;

		switch ($object)
		{
			case 'blogcat':
				if ($title == self::$config['dbtech_dbseo_blog_category_undefined'])
				{
					return false;
				}

				$idColumn 		= 'blogcategoryid';
				$tableName 		= 'blog_category';
				$whereCond 		= 'userid IN(0,' . intval($id) . ') AND title';
				$appendTitle 	= true;
				break;

			case 'thread':
				$idColumn 		= 'threadid';
				$tableName 		= 'thread';
				$whereCond 		= ($id ? 'forumid = ' . intval($id) . ' AND ' : '') . 'title';
				$appendTitle 	= true;
				$unfilterTitle 	= false;
				break;

			case 'album':
				$idColumn 		= 'albumid';
				$tableName 		= 'album';
				$whereCond		= 'userid = "' . intval($id) . '"  AND title';
				$appendTitle 	= true;
				break;

			case 'cmsnode':
				$idColumn 		= 'nodeinfo.nodeid';
				$tableName 		= 'cms_nodeinfo AS nodeinfo LEFT JOIN $cms_node AS node ON(nodeinfo.nodeid = node.nodeid)';
				$whereCond 		= 'IF(url, url, title)';
				$appendTitle 	= true;
				break;

			case 'group':
				$idColumn 		= 'groupid';
				$tableName 		= 'socialgroup';
				$whereCond 		= 'name';
				break;

			case 'groupcat':
				$idColumn 		= 'socialgroupcategoryid';
				$tableName 		= 'socialgroupcategory';
				$whereCond 		= 'title';
				$appendTitle 	= true;
				break;

			case 'tag':
				$idColumn 		= 'tagtext';
				$tableName 		= 'tag';
				$whereCond 		= 'tagtext';
				break;
		}

		if ($appendTitle)
		{
			// Prepare the title
			$title = preg_replace('#-a$#', '', $title);
		}

		// Pre-query info
		$preQuery = 'SELECT ' . $idColumn . ' AS id FROM $' . $tableName . ' WHERE ' . $whereCond . ' ';

		if ($info = self::$db->generalQuery($preQuery . ' LIKE "' . str_replace(array('%', '_', self::$config['dbtech_dbseo_rewrite_separator']) , array('\%' , '\_', ' '), $title) . '" LIMIT 1'))
		{
			// Success on the first try!
			return $info['id'];
		}

		if ($unfilterTitle)
		{
			// We need to unfilter the text to try again
			$title2 = preg_quote(self::unFilterText(htmlspecialchars(self::$config['dbtech_dbseo_rewrite_separator'] . str_replace(' ', self::$config['dbtech_dbseo_rewrite_separator'], $title) . self::$config['dbtech_dbseo_rewrite_separator'])));
			$title3 = preg_quote(self::unFilterText(htmlspecialchars(self::$config['dbtech_dbseo_rewrite_separator'] . str_replace(' ', self::$config['dbtech_dbseo_rewrite_separator'], $title) . self::$config['dbtech_dbseo_rewrite_separator'])), true);
		}
		else
		{
			// Try another like comparison
			$title2 = '%' . str_replace(self::$config['dbtech_dbseo_rewrite_separator'], '%', str_replace(array('%', '_'), array('\%' , '\_'), $title)) . '%';
		}

		if ($info = self::$db->generalQuery($preQuery . ($unfilterTitle ? 'REGEXP' : 'LIKE' ) . ' "' . $title2 . '" ORDER BY LENGTH(' . $whereCond . ') LIMIT 1'))
		{
			// Success on the second try!
			return $info['id'];
		}

		if (!$title3)
		{
			// We failed :(
			return false;
		}

		if ($info = self::$db->generalQuery($preQuery . ' REGEXP "' . $title3 . '" ORDER BY LENGTH(' . $whereCond . ') LIMIT 1'))
		{
			// Success on the third try!
			return $info['id'];
		}

		// Ultimate failure.
		return false;
	}

	/**
	 * Fetches the information for a certain object
	 *
	 * @param string $uri
	 * @param boolean $force404
	 * 
	 * @return boolean
	 */
	public static function getObjectInfo($object, $objectIds = array())
	{
		if (empty($objectIds))
		{
			// We had no IDs
			return array();
		}

		if (!is_array($objectIds))
		{
			// Ensure this is an array
			$objectIds = array($objectIds);
		}

		if ($object == self::$config['_picturestorage'] AND intval(self::$config['templateversion']) == 4)
		{
			// Special case
			return self::getAttachmentInfo($objectIds);
		}

		foreach ($objectIds as $id)
		{
			if (($info = self::$datastore->fetch($object . 'info.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			self::$cache[$object][$id] = $info;
		}

		$lookupIds = array();
		foreach ($objectIds as $id)
		{
			if (is_array(self::$cache[$object]) AND isset(self::$cache[$object][$id]))
			{
				// Ensure we grab only fresh IDs
				continue;
			}

			// We need to look this up yo
			$lookupIds[] = intval($id);
		}

		if (count($lookupIds))
		{
			switch ($object)
			{
				case 'groupsdis':
					// Pre-query info
					$query = '
						SELECT discussion.discussionid AS idfield, discussion.discussionid, discussion.groupid, groupmessage.title, groupmessage.gmid
						FROM $discussion AS discussion
						LEFT JOIN $groupmessage AS groupmessage ON(groupmessage.gmid = discussion.firstpostid)
						WHERE discussion.discussionid IN(' . implode(',', $lookupIds) . ')
					';
					break;
				
				case 'blogcustomblock':
					// Pre-query info
					$query = '
						SELECT customblockid AS idfield, userid, title
						FROM $blog_custom_block
						WHERE customblockid IN(' . implode(',', $lookupIds) . ')
					';
					break;
				
				case 'album':
					// Pre-query info
					$query = '
						SELECT albumid AS idfield, albumid, userid, title
						FROM $album
						WHERE albumid IN(' . implode(',', $lookupIds) . ')
					';
					break;
				
				case 'cmscont':
					// Pre-query info
					$query = '
						SELECT 
							node.nodeid AS idfield, 
							node.url, 
							node.parentnode, 
							node.contenttypeid, 
							node.userid, 
							node.setpublish, 
							node.publishdate, 
							node.hidden, 
							node.permissionsfrom, 
							nodeinfo.title,
							article.pagetext
						FROM $cms_node AS node
						LEFT JOIN $cms_nodeinfo AS nodeinfo USING(nodeid)
						LEFT JOIN $cms_article AS article USING(contentid)
						WHERE node.nodeid IN(' . implode(',', $lookupIds) . ')
					';
					break;
				
				case 'cms_cat':
					$query = '
						SELECT categoryid AS idfield, categoryid, parentnode, category
						FROM $cms_category
						WHERE categoryid IN(' . implode(',', $lookupIds) . ')
					';
					break;
				
				case self::$config['_picturestorage']:
					// Pre-query info
					$query = '
						SELECT picture.pictureid AS idfield, picture.pictureid, albumpicture.albumid, caption, extension
						FROM $picture AS picture
						LEFT JOIN $albumpicture AS albumpicture ON(albumpicture.pictureid = picture.pictureid)
						WHERE picture.pictureid IN(' . implode(',', $lookupIds) . ')
					';
					break;
			}

			$info = self::$db->generalQuery($query, false);
			foreach ($info as $arr)
			{
				// Build the cache
				self::$datastore->build($object . 'info.' . $arr['idfield'], $arr);

				// Cache this info
				self::$cache[$object][$arr['idfield']] = $arr;
			}
		}

		$objectInfo = array();
		if (count($objectIds) == 1)
		{
			// We have only one, return only one
			$objectInfo = self::$cache[$object][$objectIds[0]];
		}
		else
		{
			foreach ($objectIds as $key => $objectId)
			{
				// Create this array
				$objectInfo[$objectId] = self::$cache[$object][$objectId];
			}
		}

		return $objectInfo;
	}

	/**
	 * Generates a SEO title based on the text in question
	 *
	 * @param array $info
	 * 
	 * @return string
	 */
	public static function contentFilter($text)
	{
		// Init this
		$title = array();

		// Set the word list
		$wordList = preg_split('#[ \r\n\t]+#', $text, -1, PREG_SPLIT_NO_EMPTY);

		// Remove bbcode from word list
		$wordList = preg_replace('#\[.*/?\]#siU', '', $wordList);

		// Remove invalid characters from the end of the string
		$wordList = preg_replace('#\W+$#siU', '', $wordList);

		// Remove dupes
		$wordList = array_map('strtolower', array_unique($wordList));

		// Ensure we put a cap on the amount of keywords to extract
		$maxKeywords = self::$config['dbtech_dbseo_rewrite_urlkeywords'] ? self::$config['dbtech_dbseo_rewrite_urlkeywords'] : 6;

		if (!isset(self::$cache['_keyWords']))
		{
			$keywords = self::$db->generalQuery('
				SELECT *
				FROM $dbtech_dbseo_keyword
			');

			$keywords_by_priority = array();
			foreach ($keywords as $keyword)
			{
				if (!$keyword['active'])
				{
					// Inactive keyword
					continue;
				}

				// Index
				$keywords_by_priority[$keyword['priority']][] = strtolower($keyword['keyword']);
			}
		}

		// Sort by higher priority first
		krsort($keywords_by_priority);

		foreach ($keywords_by_priority as $priority => $keywords)
		{
			foreach ($keywords as $keyword)
			{
				if (count($title) >= $maxKeywords)
				{
					// Stahp.
					break 2;
				}
				
				if (array_search($keyword, $wordList) !== false)
				{
					// We got dis.
					$title[] = $keyword;
				}
			}
		}

		// And we're done here
		return implode(self::$config['dbtech_dbseo_rewrite_separator'], $title);
	}

	/**
	 * Applies filtering to the text in question
	 *
	 * @param string $uri
	 * @param boolean $force404
	 * 
	 * @return string
	 */
	public static function filterText($text, $allowedCharacters = null, $filterStopWords = true, $reversable = false, $keepTailSpaces = false, $appendA = false)
	{
//$text = 'S&#7919;a™';
//$filterStopWords = true; $reversable = false; $keepTailSpaces = false;

		static $translationTable, $translationTable2;

		if (!is_array(self::$config['dbtech_dbseo_filter_chars_custom']))
		{
			$customChars = preg_split('#\r?\n#s', self::$config['dbtech_dbseo_filter_chars_custom'], -1, PREG_SPLIT_NO_EMPTY);
			self::$config['dbtech_dbseo_filter_chars_custom'] = array();
			foreach ($customChars as $key => $val)
			{
				// Ensure we split this properly
				$val = preg_split('#\s*=>\s*#s', $val, -1, PREG_SPLIT_NO_EMPTY);
				self::$config['dbtech_dbseo_filter_chars_custom'][str_replace("'", '', $val[0])] = str_replace("'", '', $val[1]);
			}
		}

		/*
		if (!$translationTable)
		{
			$translationTable = $translationTable2 = array();
			foreach ((array)self::$config['dbtech_dbseo_filter_chars_custom'] as $key => $value)
			{
				if (strpos($key, '%') !== false AND strlen($key) > 1)
				{
					// This was an unicode encoded value
					$translationTable2[$key] = $value;
				}
				else
				{
					// Normal table
					$translationTable[$key] = $value;
				}
			}

			if (!isset($translationTable['\'']))
			{
				// Insert the separator if needed
				$text = str_replace('\'', ($reversable ? self::$config['dbtech_dbseo_rewrite_separator'] : ''), $text);
			}

			if (self::$config['dbtech_dbseo_filter_nonlatin_chars'] == 2)
			{
				$translationTable = @array_merge($translationTable, array(
					'' => 'th', '' => 'th', '' => 'dh', '' => 'dh', 
					'' => 'ss', '' => 'oe', '' => 'oe', '' => 'ae', 
					'' => 'ae', '' => 'ae', '' => 'ae', '' => 'oe', 
					'' => 'ue'
				));
			}
		}
		*/

		if ($allowedCharacters)
		{
			// Ensure the allowed characters are preg safe
			$allowedCharacters = preg_quote($allowedCharacters, '#');
		}

		// Set the valid characters
		$validCharacters = 'a-z\d\_' . $allowedCharacters;

		// Quote the separator for safety's sake
		$quotedUrlSeparator = preg_quote(self::$config['dbtech_dbseo_rewrite_separator'], '#');
		
		switch (self::$config['dbtech_dbseo_filter_nonlatin_chars'])
		{
			case 0:
				$validCharacters = '[^/\\#\,\.\+\!\?\:\s\)\(]';
				if (!$translationTable)
				{
					// Default to the custom characters
					$translationTable = self::$config['dbtech_dbseo_filter_chars_custom'];
				}

				if (!isset($translationTable['\'']))
				{
					// We need to strip apostrophes
					$text = str_replace('\'', $reversable ? self::$config['dbtech_dbseo_rewrite_separator'] : '', $text);
				}

				// Finally do the translation
				$text = strtr($text, $translationTable);
				break;

			case 1:
				if (!$reversable)
				{
					$text = str_replace('\'', '', $text);
				}
				$validCharacters = 'a-z\d\_';
				//$text = strtr($text, $translationTable);
				break;

			default:
				if (!$translationTable)
				{
					// Convert some special characters
					$translationTable = array_merge(array(
						'' => 'th', '' => 'th', '' => 'dh', '' => 'dh', 
						'' => 'ss', '' => 'oe', '' => 'oe', '' => 'ae', 
						'' => 'ae', '' => 'ae', '' => 'ae', '' => 'oe', 
						'' => 'ue'
					), self::$config['dbtech_dbseo_filter_chars_custom']);
				}

				if (!isset($translationTable['\'']))
				{
					// We need to strip apostrophes
					$text = str_replace('\'', $reversable ? self::$config['dbtech_dbseo_rewrite_separator'] : '', $text);
				}

				// Strip out a few characters
				$text = strtr(
					strtr($text, $translationTable),
					'',
					'szszyaaaaaaceeeeiiiinoooooouuuuyaaaaaaceeeeiiiinoooooouuuuyyu'
				);

				if (self::$translationTable === NULL)
				{
					// Ensure this is set
					self::$translationTable = array_flip(get_html_translation_table(HTML_ENTITIES));
				}

				// Now do this translation
				$text = strtr($text, self::$translationTable);
				break;
		}

		// Sort out what our invalid characters should be
		$invalidCharacters = (substr($validCharacters, 1, 1) == '^') ? "[" . substr($validCharacters, 2) : "[^$validCharacters]";

		/*
		if (substr($validCharacters, 1, 1) == '^')
		{
			$validCharacters = str_replace($allowedCharacters, '', $validCharacters);
			$invalidCharacters =  "[" . substr($validCharacters, 2);
		}
		else
		{
			$validCharacters .= $allowedCharacters;
			$invalidCharacters =  "[^$validCharacters]";
		}
		*/

		// Use whatever strtolower is supported
		$text = (self::$config['dbtech_dbseo_enable_utf8'] AND function_exists('mb_strtolower')) ? mb_strtolower($text, 'UTF-8') : strtolower($text);

		$text = str_replace('&amp;', ' and ', $text);
		$text2 = preg_replace('#&\#?[a-z\d]+;#i', ' ', $text);
		if (preg_match('#\S#', $text2))
		{
			$text = $text2;
		}
		$text = str_replace('&', ' and ', $text);
		
		if ($validCharacters)
		{	
			$text = preg_replace('#' . $invalidCharacters . '+#s', self::$config['dbtech_dbseo_rewrite_separator'], $text);
		}

		$doReplaceWordlist = true;
		$keyWordCount = self::$config['dbtech_dbseo_rewrite_urlkeywords'] + 1;
		if (self::$config['dbtech_dbseo_rewrite_separator'] == '_')
		{
			$text = str_replace('_', ' ', $text);
		}

		if (
			!$reversable AND 
			self::$config['dbtech_dbseo_removestopwords'] == 2 AND 
			$filterStopWords AND 
			self::$config['dbtech_dbseo_stopwordlist'] AND 
			self::$config['dbtech_dbseo_rewrite_urlkeywords'] > 0
		)
		{
			preg_match_all('#([^' . $quotedUrlSeparator . ' ]+)#s' . (self::$config['dbtech_dbseo_enable_utf8'] ? 'u' : ''), $text, $wordMatches);
			preg_match_all('#\b(' . self::$config['dbtech_dbseo_stopwordlist'] . ')\b#s', $text, $stopWordMatches);
			$keyWordCount = count($wordMatches[1]) - count($stopWordMatches[1]);
		}
		else if ($reversable OR !self::$config['dbtech_dbseo_rewrite_urlkeywords'])
		{
			$doReplaceWordlist = false;
		}

		if ($filterStopWords)
		{
			// Sort out the stopword filtering
			self::filterStopWords($text, $keyWordCount);
		}
		
		if ($doReplaceWordlist)
		{
			$text = preg_replace('#(([^' . $quotedUrlSeparator . ']+' . $quotedUrlSeparator . '*){' . self::$config['dbtech_dbseo_rewrite_urlkeywords'] . '}).*$#s' . (self::$config['dbtech_dbseo_enable_utf8'] ? 'u' : ''), '\\1', $text);
		}

		$text = urlencode($text);
		/*
		if ($translationTable2)
		{
			// Translate the string
			$text = strtr($text, $translationTable2);
		}
		*/

		if (self::$config['dbtech_dbseo_rewrite_separator'] != '' AND !($reversable AND !$keepTailSpaces))
		{
			$expression = ($reversable AND $keepTailSpaces) ? array('#(' . $quotedUrlSeparator . '){2,}#') : array('#(' . $quotedUrlSeparator . '){2,}#', '#^(' . $quotedUrlSeparator . ')+#', '#(' . $quotedUrlSeparator . ')$#');
			$replacement = array(self::$config['dbtech_dbseo_rewrite_separator'], '', '');
			$text = preg_replace($expression, $replacement, $text);
		}

		if (!$text)
		{
			// Fallback value
			$text = 'a';
		}
		else if ($appendA AND preg_match('#[-_\s](?:post|print)?\d+$#', $text))
		{
			// Only do this in certain cases
			$text .= ($text ? self::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
		}

		return $text;
	}

	/**
	 * Filters the stop words from the text
	 *
	 * @param string $text
	 * 
	 * @return void
	 */
	public static function filterStopWords(&$text, $keyWordCount = NULL, $reversable = false)
	{
		if (!self::$config['dbtech_dbseo_removestopwords'] OR !self::$config['dbtech_dbseo_stopwordlist'])
		{
			return;
		}

		if ($keyWordCount === NULL)
		{
			$keyWordCount = self::$config['dbtech_dbseo_rewrite_urlkeywords'] + 1;
			
			if (
				!$reversable AND 
				self::$config['dbtech_dbseo_removestopwords'] == 2 AND 
				self::$config['dbtech_dbseo_rewrite_urlkeywords'] > 0
			)
			{
				preg_match_all('#([^' . preg_quote(self::$config['dbtech_dbseo_rewrite_separator'], '#') . ' ]+)#s' . (self::$config['dbtech_dbseo_enable_utf8'] ? 'u' : ''), $text, $wordMatches);
				preg_match_all('#\b(' . self::$config['dbtech_dbseo_stopwordlist'] . ')\b#s', $text, $stopWordMatches);
				$keyWordCount = count($wordMatches[1]) - count($stopWordMatches[1]);
			}
		}

		$textBackup = $text;
		if ($keyWordCount >= self::$config['dbtech_dbseo_rewrite_urlkeywords'])
		{
			// Just remove all stopwords
			$text = preg_replace('#\b(' . self::$config['dbtech_dbseo_stopwordlist'] . ')\b#i', '', $text);
		}
		else
		{
			// Replace stopwords while we have enough keywords
			self::$cache['keyWordCount2'] = self::$config['dbtech_dbseo_rewrite_urlkeywords'] - $keyWordCount;

			// Replace stopwords
			$text = preg_replace_callback(
				'#\b(' . self::$config['dbtech_dbseo_stopwordlist'] . ')\b#i', 
				array('DBSEO', 'replaceStopWords'), 
				$text
			);
		}

		// Determine first and last char
		$firstChar = substr($text, 0, 1);
		$lastChar = substr($text, -1);

		// Set some important stuff
		$start = 0;
		$length = strlen($text);

		// Whether we should replace
		$doReplace = false;

		if ($firstChar == self::$config['dbtech_dbseo_rewrite_separator'])
		{
			// We need a replacement
			$doReplace = true;
			$start = 1;
		}

		if ($lastChar == self::$config['dbtech_dbseo_rewrite_separator'])
		{
			// We need a replacement
			$doReplace = true;			
			$length = -1;
		}

		if ($doReplace)
		{
			// Do a substr
			$text = substr($text, $start, $length);
		}

		if (self::$config['dbtech_dbseo_rewrite_separator'] != '' AND !$reversable)
		{
			// Quote the separator for safety's sake
			$quotedUrlSeparator = preg_quote(self::$config['dbtech_dbseo_rewrite_separator'], '#');			
			$expression = ($reversable AND $keepTailSpaces) ? array('#(' . $quotedUrlSeparator . '){2,}#') : array('#(' . $quotedUrlSeparator . '){2,}#', '#^(' . $quotedUrlSeparator . ')+#', '#(' . $quotedUrlSeparator . ')$#');
			$replacement = array(self::$config['dbtech_dbseo_rewrite_separator'], '', '');
			$text = preg_replace($expression, $replacement, $text);
		}

		if (!$text)
		{
			$text = $textBackup;
		}
	}

	/**
	 * Creates a regexp that matches the original string
	 *
	 * @param string $text
	 * @param boolean $anySpacer
	 * 
	 * @return string
	 */
	public static function unFilterText($text, $anySpacer = false)
	{
		if (!is_array(self::$config['dbtech_dbseo_filter_chars_custom']))
		{
			$customChars = preg_split('#\r?\n#s', self::$config['dbtech_dbseo_filter_chars_custom'], -1, PREG_SPLIT_NO_EMPTY);
			self::$config['dbtech_dbseo_filter_chars_custom'] = array();
			foreach ($customChars as $key => $val)
			{
				// Ensure we split this properly
				$val = preg_split('#\s*=>\s*#s', $val, -1, PREG_SPLIT_NO_EMPTY);
				self::$config['dbtech_dbseo_filter_chars_custom'][str_replace("'", '', $val[0])] = str_replace("'", '', $val[1]);
			}
		}

		if (self::$config['dbtech_dbseo_filter_nonlatin_chars'] == 1)
		{
			$replace = array(
				(self::$config['dbtech_dbseo_rewrite_separator'] . 'and' . self::$config['dbtech_dbseo_rewrite_separator']) => '#**%**#', 
				self::$config['dbtech_dbseo_rewrite_separator'] => '(&[\#\da-z]*;|[^a-z\d])+'
			);
		}
		else
		{
			$replace = array(
				'ue' 	=> '(ue|)', 
				'oe' 	=> '(oe||_|_)', 
				'ae' 	=> '(ae|||)', 
				'ss' 	=> '(ss|)', 
				(self::$config['dbtech_dbseo_rewrite_separator'] . 'and' . self::$config['dbtech_dbseo_rewrite_separator']) => '#**%**#',
				's' 	=> '[s]',
				'z' 	=> '[z]',
				'y' 	=> '[y]',
				'a' 	=> '[a]',
				'c' 	=> '[cc]',
				'e' 	=> '[e]',
				'i' 	=> '[i]',
				'n' 	=> '[n]',
				'o' 	=> '[o]',
				'th' 	=> '(th||)',
				'dh' 	=> '(dh||)',
				'u' 	=> '([u]|u||)',
				self::$config['dbtech_dbseo_rewrite_separator'] => '(&[\#\da-z]*;|[^a-z\d])*',
			);
		}

		if ($anySpacer)
		{
			// The spacer can be any char
			$replace[self::$config['dbtech_dbseo_rewrite_separator']] = '.*';
		}

		$replace2 = array();
		foreach (self::$config['dbtech_dbseo_filter_chars_custom'] as $key => $value)
		{
			if (isset($replace[$value]))
			{
				if ($replace[$value][0] == '(')
				{
					$replace[$value] = "($key|" . substr($replace[$value], 1);
				}
				else
				{
					$replace[$value] = "($key|" . $replace[$value] . ")";
				}
			}
			else
			{
				if (isset($replace[$value[0]]))
				{
					$replace2[$value] = "($key|$value)";
				}
				else
				{
					$replace[$value] = "($key|$value)";
				}
			}
		}

		$replace = array_merge($replace2, $replace);
		$replace['#**%**#'] = '[^a-z\d]*(and|&amp;|&)[^a-z\d]*';

		$text = str_replace(array_keys($replace), $replace, $text);

		return '^(&[\#\da-z]*;|[^a-z\d])*' . $text . '(&[a-z]*;|[^a-z\d])*$';
	}

	/**
	 * Checks for and redirects to proper URLs if needed
	 *
	 * @param string $url
	 * @param boolean $fileExists
	 * @param boolean $fileExistsDeep
	 * 
	 * @return mixed
	 */
	public static function redirectUrl(&$url, &$fileExists, &$fileExistsDeep)
	{
		if (!count(self::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			self::initUrlCache();
		}

		// Fetch the URL to our thread icon
		preg_match('#^(.+?)(_(?:ltr|rtl)?)(\.gif)$#', $url, $_treeIcon);
		$iconFile = isset($_treeIcon[1]) ? $_treeIcon[1] . $_treeIcon[3] : '';

		if (!$iconFile)
		{
			// Ensure this is set
			$iconFile = $url;
		}

		if (self::$config['dbtech_dbseo_rewrite_navbullet'])
		{
			$gifpos = strpos($url, '.gif');

			do
			{
				if ($gifpos === false)
				{
					// Not a gif
					break;
				}

				if (substr($url, 0, strlen(self::$config['dbtech_dbseo_navbullet_prefix'])) != self::$config['dbtech_dbseo_navbullet_prefix'])
				{
					// Not a nav bullet icon
					break;
				}

				// Shorthand
				$_url = substr($iconFile, strlen(self::$config['dbtech_dbseo_navbullet_prefix']), $gifpos + 4);

				if (
					!self::checkUrl('NavBullet_NavBullet_Thread', $_url, true) AND
					!self::checkUrl('NavBullet_NavBullet_Forum', $_url, true)
				)
				{
					// Didn't match thread or forum icon
					break;
				}

				// Construct the file path
				$_filePath = $fileExists ? $url : 'images/misc/navbits_finallink' . $_treeIcon[2] . '.gif';

				// Send some shiny headers
				header('Content-type: image/gif');
				header('Content-Length: ' . filesize($_filePath));
				
				// Display the image
				die(file_get_contents($_filePath));
			}
			while (false);
		}
		else if (
			strpos(DBSEO_HTTP_HOST, 'localhost') !== false AND
			self::$config['dbtech_dbseo_www'] AND 
			strpos(DBSEO_HTTP_HOST, 'www.') === false AND
			strpos(self::$config['bburl'], 'www.') !== false
		)
		{
			// Redirect to the www-included URL
			self::safeRedirect(self::$config['bburl'] . '/' . $url);
		}

		if (DBSEO_SPIDER)
		{
			// If we're a spider
			$nonClean = array('pp', 'highlight', 'order', 'sort', 'daysprune', 'referrerid');
			foreach ($nonClean as $var)
			{
				if (isset($_GET[$var]))
				{
					// We had one of the non-cleanable variables
					self::safeRedirect($_queryFile, $nonClean);
				}
			}
		}

		// By default, assume we haven't processed nothin'
		$_processed = false;

		do
		{
			if ($_POST OR !$fileExists)
			{
				// Ensure we don't overwrite $_fileName with anything
				break;
			}

			/*
			if (DBSEO_RELPATH OR $fileExistsDeep)
			{
				// Either a relative URL or an actual file
				break;
			}
			*/

			/*DBTECH_PRO_START*/
			if (DBSEO_SPIDER)
			{
				// Track spider hit
				self::trackSpider(DBSEO_BASEURL);
			}
			/*DBTECH_PRO_END*/

			// Even if we fail the rewrite checks or whatever, still count as processed
			$_processed = true;

			// Detect file name
			$_strippedFileName = preg_replace('/[^\w\.-]/i', '', DBSEO_BASEURL);

			// Detect script alias if any exists
			$_strippedFileName = isset(self::$cache['_scriptAlias'][$_strippedFileName]) ? self::$cache['_scriptAlias'][$_strippedFileName] : $_strippedFileName;

			if (!$_strippedFileName OR !file_exists(DBSEO_CWD . '/dbtech/dbseo/includes/scripts/' . $_strippedFileName))
			{
				// Get out of this area
				break;
			}

			// Include the file
			require_once(DBSEO_CWD . '/dbtech/dbseo/includes/scripts/' . $_strippedFileName);

			$class = 'DBSEO_Script_' . ucfirst(pathinfo($_strippedFileName, PATHINFO_FILENAME));

			if (!class_exists($class))
			{
				// Git oot.
				return false;
			}

			if (!method_exists($class, 'redirectUrl'))
			{
				// Git oot.
				return false;
			}

			$result = call_user_func_array(array($class, 'redirectUrl'), array(&$url, &$fileExists, &$fileExistsDeep));
			if (is_bool($result) === false)
			{
				// We had a different result
				return $result;
			}
		}
		while (false);

		if (!$_processed AND !$fileExists)
		{
			// Check custom URL
			if ($newUrl = self::createUrl('Custom_CustomRewrite', $url))
			{
				// Get rid of this
				$newUrl = str_replace('[NF]', '', $newUrl);

				if (DBSEO_REQURL != $newUrl AND strpos($newUrl, $url) === false)
				{
					// The URL was different
					if (DBSEO_RELPATH AND strpos($newUrl, DBSEO_RELPATH) === false)
					{
						// Add the relpath to the URL
						$newUrl = DBSEO_RELPATH . $newUrl;
					}

					// Redirect to the new URL
					self::safeRedirect($newUrl, array(), true);
				}
			}
		}

		// Ensure we don't overwrite $_fileName with anything
		return '';
	}

	/**
	 * Automatically adjusts a URL based on parameters
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function adjustUrl($_requestUrl, $excludedParams = array(), $forceRedirect = false)
	{
		// Initialise some important variables
		$decodedUrl = urldecode($_requestUrl);
		$doubleDecode = urldecode($decodedUrl);
		$_requestUrl2 = preg_replace('#\?.*$#', '', DBSEO_REQURL);

		if (
			(
				$_requestUrl != $_requestUrl2 AND 
				!isset($_GET['vbseodirect']) AND  # COMPATIBILITY
				!isset($_GET['dbseodirect']) AND 
				(
					(strpos(DBSEO_URL_CLEAN, DBSEO_URL_BASE_PATH) !== false) OR
					/*DBTECH_PRO_START*/
					(self::$config['dbtech_dbseo_custom_blog'] 	AND strpos(self::$config['dbtech_dbseo_custom_blog'], 	DBSEO_HTTP_HOST) !== false) OR
					(self::$config['dbtech_dbseo_custom_cms'] 	AND strpos(self::$config['dbtech_dbseo_custom_cms'], 	DBSEO_HTTP_HOST) !== false) OR
					/*DBTECH_PRO_END*/
					(strpos(self::$config['dbtech_dbseo_rewrite_rule_blogs'], 	'://') !== false AND strpos(DBSEO_URL_CLEAN, self::$config['dbtech_dbseo_rewrite_rule_blogs']) 		!== false) OR
					(strpos(self::$config['dbtech_dbseo_rewrite_rule_cmshome'], '://') !== false AND strpos(DBSEO_URL_CLEAN, self::$config['dbtech_dbseo_rewrite_rule_cmshome']) 	!== false)
				) AND 
				($doubleDecode != $_requestUrl2) AND 
				($doubleDecode != urldecode(DBSEO_REQURL)) AND 
				($_requestUrl != DBSEO_URL_BASE_PATH . $_requestUrl2) AND (
					($_requestUrl == $decodedUrl) OR 
					($_requestUrl != substr($decodedUrl, 0, strlen($_requestUrl)))
				)
			) OR $forceRedirect
		)
		{
			// URL needed adjustment
			self::safeRedirect($_requestUrl, $excludedParams);
		}
	}

	/**
	 * Resolves a SEO'd URL back to its original counterpart
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function urlLookup(&$url, &$fileExists, &$fileExistsDeep)
	{
		// Default retval
		$_retVal = array(false, '', '');

		if (!$url OR $fileExists OR $fileExistsDeep)
		{
			return $_retVal;
		}

		// Check custom redirects
		self::resolveUrl('Custom_CustomRedirect', $url);

		if ($_fileName = self::resolveUrl('Custom_CustomRewrite', $url) OR count(self::$suggestedUrls))
		{
			// Ensure we've updated our environment
			//self::updateEnvironment(DBSEO_RELPATH . $_fileName);

			// Parse the resulting file
			$parsedUrl = parse_url(preg_replace('#\?.*$#', '', $_fileName));
			
			// We're done here
			return array(!count(self::$suggestedUrls), $parsedUrl['path'], array_shift(self::$suggestedUrls));
		}

		if (DBSEO_RELPATH)
		{
			// We have a relpath or whatever
			return $_retVal;
		}

		// By default, we need to continue
		$_continue = true;

		if (self::$config['dbtech_dbseo_persistenturl'])
		{
			if ($info = self::$db->generalQuery('
				SELECT *
				FROM $dbtech_dbseo_resolvedurl
				WHERE seourl = \'' . self::$db->escapeString($url) . '\'
				LIMIT 1
			'))
			{
				// Set environment
				self::updateEnvironment($info['forumurl']);

				// Set file name
				$_fileName = $_SERVER['DBSEO_FILE'];

				// Return the proper values
				return array(true, $_fileName, '');
			}
		}

		// Init some arrays we need
		$_formatsByLibrary = $_formatPriorities = $_urlMatches = array();

		//echo "<pre>";
		//print_r(self::$libraries);
		//die();

		foreach (self::$libraries as $optionGroup => $options)
		{
			if (!self::$config['dbtech_dbseo_rewrite_' . strtolower($optionGroup)])
			{
				// We're not rewriting this at all
				//echo "<pre>$optionGroup</pre>";
				continue;
			}

			foreach ($options as $option => $optionInfo)
			{
				if ($optionInfo['subsetting'])
				{
					if (!self::$config['dbtech_dbseo_rewrite_' . strtolower($optionGroup) . $optionInfo['subsetting']])
					{
						// We're not rewriting this at all
						continue;
					}
				}

				if ($optionInfo['priority'] == -1)
				{
					// Skip this
					continue;
				}

				// Store this information in a lookup-friendly way
				$_formatsByLibrary[$optionGroup . '_' . $option] =& self::$libraries[$optionGroup][$option];

				// Store this information in a sort-friendly way
				$_formatPriorities[$optionGroup . '_' . $option] = $optionInfo['priority'];
			}
		}

		//echo "<pre>";
		//print_r($_formatPriorities);
		//die();

		// Sort by priority
		asort($_formatPriorities, SORT_NUMERIC);

		// All the URL checks go here
		foreach ($_formatPriorities as $format => $priority)
		{
			$_parsedUrl = self::checkUrl($format, $url, false, $_formatsByLibrary[$format]['strict']);
			if ($_parsedUrl !== NULL)
			{
				// Store this potential URL match
				$_urlMatches[] = array('format' => $format, 'info' => $_parsedUrl, 'history' => false);
			}
		}

		if (!count($_urlMatches))
		{
			// We had no matches, let's see what the history has for us

			// Store the URL history
			$urlHistory = array();

			$info = self::$db->generalQuery('
				SELECT *
				FROM $dbtech_dbseo_urlhistory
			', false);
			foreach ($info as $arr)
			{
				if (!isset($urlHistory[$arr['setting']]))
				{
					// Store an array of values for this setting
					$urlHistory[$arr['setting']] = array();
				}

				// Store this value
				$urlHistory[$arr['setting']][] = array('regexpformat' => $arr['regexpformat'], 'rawformat' => $arr['rawformat']);
			}

			// All the URL checks go here
			foreach ($_formatPriorities as $format => $priority)
			{
				if (!isset($urlHistory[$format]))
				{
					// This format had no history
					continue;
				}

				foreach ($urlHistory[$format] as $history)
				{
					$_parsedUrl = self::checkUrlHistory($format, $history['regexpformat'], $history['rawformat'], $url, false, $_formatsByLibrary[$format]['strict']);
					if ($_parsedUrl !== NULL)
					{
						// Store this potential URL match
						$_urlMatches[] = array('format' => $format, 'info' => $_parsedUrl, 'history' => true);
					}
				}
			}			
		}

		// No need for this anymore
		unset($_formatPriorities);

		// Default to fail
		$successfulUrl = false;

		// Default to no file
		$_fileName = '';

		//if (!$_SERVER['DBSEO_SUGGESTED_URI'])
		//{
		do
		{
			// Grab the first url match
			$urlMatch = array_shift($_urlMatches);

			// Resolve URL via the library
			$successfulUrl = self::resolveUrl($urlMatch['format'], $urlMatch['info'], $urlMatch['history']);
		}
		while (count($_urlMatches) AND !$successfulUrl);
		

		// Default
		$_suggestedUrl = self::$suggestedUrls[$urlMatch['format']];

		if (!$successfulUrl AND count(self::$suggestedUrls))
		{
			// We need to super guess the URL
			$_suggestedUrl = array_shift(self::$suggestedUrls);
		}

		if ($_suggestedUrl)
		{
			// We need to redirect
			$successfulUrl = false;
		}
		else
		{
			if ($successfulUrl)
			{
				if ($urlMatch['history'])
				{
					// Set environment
					self::updateEnvironment($successfulUrl);

					// Reconstruct the URL and set it as the suggested URL
					$_suggestedUrl = self::createUrl($urlMatch['format'], $_REQUEST);

					// Set the various query string variables
					$_SERVER['QUERY_STRING'] = $_ENV['QUERY_STRING'] = $GLOBALS['QUERY_STRING'] = $query;
					
					// Parse the query into neat little key->value pairs with automagic urldecode
					parse_str($_SERVER['QUERY_STRING'], $params);

					foreach ($params as $name => $value)
					{
						// Set this now instead
						unset($_REQUEST[$name], $_GET[$name]);
					}

					// We need to redirect
					$successfulUrl = false;
				}
				else
				{
					if (self::$config['dbtech_dbseo_persistenturl'])
					{
						if (!$info = self::$db->generalQuery('
							SELECT *
							FROM $dbtech_dbseo_resolvedurl
							WHERE seourl = \'' . self::$db->escapeString($url) . '\'
						'))
						{
							// Update our bot info (spider)
							self::$db->modifyQuery('
								INSERT INTO $dbtech_dbseo_resolvedurl
									(forumurl, seourl, urldata, format)
								VALUES (
									\'' . self::$db->escapeString($successfulUrl) . '\',
									\'' . self::$db->escapeString($url) . '\',
									\'' . self::$db->escapeString(trim(serialize($urlMatch['info']))) . '\',
									\'' . self::$db->escapeString($urlMatch['format']) . '\'
								)
							');
						}
					}

					// Set environment
					self::updateEnvironment($successfulUrl);

					// Set file name
					$_fileName = $_SERVER['DBSEO_FILE'];
				}
			}
		}
		//}

		// Return the proper values
		return array((bool)$successfulUrl, $_fileName, $_suggestedUrl);
	}

	/**
	 * Checks a URL against a specified format.
	 *
	 * @param string $format
	 * @param string $url
	 * @param boolean $partial
	 * @param boolean $strict
	 * 
	 * @return mixed
	 */
	public static function checkUrl($format, $url, $partial = false, $strict = false)
	{
		if (!count(self::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			self::initUrlCache();
		}

		// Prepare the regexp format
		$preparedFormat = explode('_', $format, 2);
		$regexpFormat 	= self::$cache['preparedurls'][strtolower($preparedFormat[0])][$preparedFormat[1]];
		$rawFormat 		= self::$cache['rawurls'][strtolower($preparedFormat[0])][$preparedFormat[1]];

		switch (strtolower($preparedFormat[0]))
		{
			case 'attachment':
				if (strpos($url, self::$config['dbtech_dbseo_attachment_prefix']) === 0)
				{
					// Shorthand
					$url = substr($url, strlen(self::$config['dbtech_dbseo_attachment_prefix']));
				}
				break;

			case 'avatar':
				$url = substr($url, strlen(self::$config['dbtech_dbseo_avatar_prefix']));
				break;
		}

		// By default we're not in a folder
		$isFolder = false;
		if (substr($regexpFormat, -1) == '/' AND substr($url, -1) != '/' AND !file_exists($url))
		{
			// Whoops I guess we are, append a query string option
			$isFolder = true;
			$regexpFormat .= '?';
		}

		$regexpFormat = $partial ? '#' . $regexpFormat . '#' : '#^' . $regexpFormat . '$#';
		$urlToCheck = $url;
		if (strpos($regexpFormat, 'http\://') !== false AND strpos($urlToCheck, 'http:') === false AND strpos(DBSEO_URL_CLEAN, DBSEO_URL_BASE_PATH) === false)
		{
			// The rule had a URL in it
			$urlToCheck = DBSEO_URL_BASE_PATH  . '/' . $url;
		}

		/*
		if ($regexpFormat == '#^members/list/([a-z]|0|all)(\d+)\.html$#')
		{
			echo "<pre>";
			print_r($regexpFormat);
			echo "<br />";
			print_r($urlToCheck);
			echo "</pre>";
		}
		*/

		if (!preg_match($regexpFormat, $urlToCheck, $matches))
		{
			// No matches :(
			return null;
		}

		if ($isFolder AND $url)
		{
			// Suggest a URL
			self::$suggestedUrls[$format] = $url . '/';

			if ($strict)
			{
				// We're only checking strict matches here
				return null;
			}
		}

		$fields = $results = array();
		if (preg_match_all('#%([a-z_]+)%#', $rawFormat, $matches2, PREG_PATTERN_ORDER))
		{
			// Prepare the fields to use
			$fields = array_values(array_unique($matches2[1]));
			foreach ($fields as $key => $field)
			{
				// Construct the results array
				$results[$field] = $matches[$key + 1];
			}
		}

		return $results;
	}

	/**
	 * Checks a URL against a specified format.
	 *
	 * @param string $format
	 * @param string $regexpFormat
	 * @param string $rawFormat
	 * @param string $url
	 * @param boolean $partial
	 * @param boolean $strict
	 * 
	 * @return mixed
	 */
	public static function checkUrlHistory($format, $regexpFormat, $rawFormat, $url, $partial = false, $strict = false)
	{
		if (!count(self::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			self::initUrlCache();
		}

		// Prepare the regexp format
		$preparedFormat = explode('_', $format, 2);

		switch (strtolower($preparedFormat[0]))
		{
			case 'attachment':
				if (strpos($url, self::$config['dbtech_dbseo_attachment_prefix']) === 0)
				{
					// Shorthand
					$url = substr($url, strlen(self::$config['dbtech_dbseo_attachment_prefix']));
				}
				break;

			case 'avatar':
				$url = substr($url, strlen(self::$config['dbtech_dbseo_avatar_prefix']));
				break;
		}

		// By default we're not in a folder
		$isFolder = false;
		if (substr($regexpFormat, -1) == '/' AND substr($url, -1) != '/' AND !file_exists($url))
		{
			// Whoops I guess we are, append a query string option
			$isFolder = true;
			$regexpFormat .= '?';
		}

		$regexpFormat = $partial ? '#' . $regexpFormat . '#' : '#^' . $regexpFormat . '$#';
		$urlToCheck = $url;
		if (strpos($regexpFormat, 'http\://') !== false AND strpos($urlToCheck, 'http:') === false AND strpos(DBSEO_URL_CLEAN, DBSEO_URL_BASE_PATH) === false)
		{
			// The rule had a URL in it
			$urlToCheck = DBSEO_URL_BASE_PATH  . '/' . $url;
		}

		/*
		if ($regexpFormat == '#^members/list/([a-z]|0|all)(\d+)\.html$#')
		{
			echo "<pre>";
			print_r($regexpFormat);
			echo "<br />";
			print_r($urlToCheck);
			echo "</pre>";
		}
		*/

		if (!preg_match($regexpFormat, $urlToCheck, $matches))
		{
			// No matches :(
			return null;
		}

		if ($isFolder AND $url)
		{
			// Suggest a URL
			self::$suggestedUrls[$format] = $url . '/';

			if ($strict)
			{
				// We're only checking strict matches here
				return null;
			}
		}

		$fields = $results = array();
		if (preg_match_all('#%([a-z_]+)%#', $rawFormat, $matches2, PREG_PATTERN_ORDER))
		{
			// Prepare the fields to use
			$fields = array_values(array_unique($matches2[1]));
			foreach ($fields as $key => $field)
			{
				// Construct the results array
				$results[$field] = $matches[$key + 1];
			}
		}

		return $results;
	}

	/**
	 * Creates a SEO'd URL based on the current environment.
	 * 
	 * @return mixed
	 */
	public static function createAnyUrl()
	{
		if (!$_SERVER['DBSEO_FILE'] OR !file_exists(DBSEO_CWD . '/dbtech/dbseo/includes/scripts/' . $_SERVER['DBSEO_FILE']))
		{
			// Git oot.
			return false;
		}

		// Include the file
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/scripts/' . $_SERVER['DBSEO_FILE']);

		$class = 'DBSEO_Script_' . ucfirst(pathinfo($_SERVER['DBSEO_FILE'], PATHINFO_FILENAME));

		if (!class_exists($class) OR !method_exists($class, 'createUrl'))
		{
			// Git oot.
			return false;
		}

		return call_user_func_array(array($class, 'createUrl'), array($_REQUEST));
	}

	/**
	 * Creates a SEO'd URL based on the specified library.
	 *
	 * @param string $library
	 * @param array $data
	 * 
	 * @return mixed
	 */
	public static function createUrl($library, $data = array())
	{
		if (!$library)
		{
			// Sadly we couldn't handle this
			return false;
		}

		if (!count(self::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			self::initUrlCache();
		}

		// Sort out this addition
		$libraryParts = explode('_', $library, 2);

		// Strip non-valid characters
		$libraryParts[0] = strtolower(preg_replace('/[^\w-]/i', '', $libraryParts[0]));

		if (!isset(self::$cache['preparedurls'][$libraryParts[0]]))
		{
			// Git oot.
			return false;
		}

		if (!file_exists(DBSEO_CWD . '/dbtech/dbseo/includes/library/' . $libraryParts[0] . '.php'))
		{
			// Git oot.
			return false;
		}

		// This file holds all subclasses as well
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/' . $libraryParts[0] . '.php');

		$class = 'DBSEO_Rewrite_' . $libraryParts[1];
		if (!class_exists($class))
		{
			// Git oot.
			return false;
		}

		if (!method_exists($class, 'createUrl'))
		{
			// Git oot.
			return false;
		}

		return call_user_func(array($class, 'createUrl'), $data);
	}

	/**
	 * Creates a SEO'd CMS URL based on the specified library.
	 *
	 * @param string $library
	 * @param array $data
	 * 
	 * @return mixed
	 */
	public static function createCMSUrl($routeInfo, $routeType = '', $data = array())
	{
		if (!count(self::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			self::initUrlCache();
		}

		$_isDefault = false;
		if (!$routeInfo AND $data['page'])
		{
			// We had a page but no route info
			$routeInfo = self::$config['default_page'];
			$_isDefault = true;
			$routeType = 'section';
		}

		// Match potential URLs
		preg_match('#^(list/)?(category|content|author|section)?/?(\d+)-?(.+?)?(?:/(?:view/)?(\d+))?$#', $routeInfo, $matches);
		$_isList = $matches[1];
		
		if (!$routeType)
		{
			// We had no route type set
			$routeType = $matches[2] ? $matches[2] : ($_isDefault ? 'section' : ($_isList ? 'category' : 'content'));
		}
		
		if (!$matches AND (!$routeInfo OR $routeInfo == 'content'))
		{
			// We tried to set content, but we had no route info
			$routeType = $matches = 'home';
		}
		
		if (preg_match('#/(edit|addcontent|rate)$#', $routeInfo) OR strpos(implode(' ', array_keys($data)), '/rate') !== false)
		{
			// We're not rewriting this
			return '';
		}

		switch ($routeType)
		{
			case 'category':
				$data['categoryid'] = $matches[3];
				$data['title'] = $matches[4];
				break;

			case 'content':
				$data['entryid'] = $matches[3];
				if (($contenttypeid = self::$datastore->fetch('contenttype.' . $data['entryid'])) === false)
				{
					// Test if we have a direct username match
					$contentInfo = self::$db->generalQuery('
						SELECT contenttypeid 
						FROM $cms_node 
						WHERE nodeid = ' . intval($data['entryid']) . '
					');

					// Store this
					$contenttypeid = $contentInfo['contenttypeid'];

					// Build the cache
					self::$datastore->build('contenttype.' . $data['entryid'], $contenttypeid);			
				}

				if (self::getContentTypeById($contenttypeid) == 'cms_section')
				{
					// Set the content type
					$routeType = 'section';
					$data['sectionid'] = $data['entryid'];
				}

				if ($matches[5])
				{
					// Multi-page article
					$data['page'] = $matches[5];
				}

				break;

			case 'author':
				$data['userid'] = $matches[3];
				break;
		}

		// Shorthand
		$libraries = array(
			'section' 	=> 'CMS_CMSSection',
			'category' 	=> 'CMS_CMSCategory',
			'content' 	=> 'CMS_CMSEntry',
			'author'  	=> 'CMS_CMSAuthor',
			'home' 		=> 'CMS_CMSHome',
		);

		if (!$routeType OR !$matches OR !isset($libraries[$routeType]))
		{
			// Epic fail
			return '';
		}

		// And we're done
		return self::createUrl($libraries[$routeType] . ($data['page'] > 1 ? '_Page' : ''), $data);
	}

	/**
	 * Creates a SEO'd URL based on the specified library.
	 *
	 * @param string $library
	 * @param array $data
	 * 
	 * @return mixed
	 */
	public static function resolveUrl($library, $data = array(), $history = false)
	{
		if (!$library)
		{
			// Sadly we couldn't handle this
			return false;
		}

		if (!count(self::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			self::initUrlCache();
		}

		// Sort out this addition
		$libraryParts = explode('_', $library, 2);

		// Strip non-valid characters
		$libraryParts[0] = strtolower(preg_replace('/[^\w-]/i', '', $libraryParts[0]));

		if (!isset(self::$cache['preparedurls'][$libraryParts[0]]))
		{
			// Git oot.
			return false;
		}

		if (!file_exists(DBSEO_CWD . '/dbtech/dbseo/includes/library/' . $libraryParts[0] . '.php'))
		{
			// Git oot.
			return false;
		}

		// This file holds all subclasses as well
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/' . $libraryParts[0] . '.php');

		$class = 'DBSEO_Rewrite_' . $libraryParts[1];
		if (!class_exists($class))
		{
			// Git oot.
			return false;
		}

		if (!method_exists($class, 'resolveUrl'))
		{
			// Git oot.
			return false;
		}

		return call_user_func(array($class, 'resolveUrl'), $data);
	}

	/**
	 * Fetches the user info based on parameters
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getPicturePage($pictureid, $commentid)
	{
		$perpage = intval(self::$config['pc_perpage']);

		$hook_query_join = $hook_query_where = '';
		if (intval(self::$config['templateversion']) == 4)
		{
			// vB4
			$hook_query_where = 'AND attachment.attachmentid = ' . intval($pictureid);
			$hook_query_join = 'LEFT JOIN $attachment AS attachment USING(filedataid)';
		}
		else
		{
			// vB3
			$hook_query_where = 'AND pictureid = ' . intval($pictureid);
		}

		//if (($count = self::$datastore->fetch('picturecomment.' . $pictureid . '.' . $commentid)) === false)
		//{
			// Grab our comment count
			$count = self::$db->generalQuery('
				SELECT COUNT(*) AS comments
				FROM $picturecomment AS picturecomment
				' . $hook_query_join . '
				WHERE picturecomment.state = \'visible\'
					AND picturecomment.commentid <= ' . intval($commentid) . '
					' . $hook_query_where . '
			');

			// Build the cache
			//self::$datastore->build('picturecomment.' . $pictureid . '.' . $commentid, $count);
		//}

		return $perpage ? ceil($count['comments'] / $perpage) : 1;
	}

	/**
	 * Fetches the group message page info based on parameters
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getGroupMessagePage(&$discussionid, $groupmessageid)
	{
		global $vbulletin;

		//if (($commentCount = self::$datastore->fetch('groupmessagepage.' . $discussionid . '.' . $groupmessageid . '.' . $vbulletin->userinfo['userid'])) === false)
		//{
			$commentCount = 0;
			$gotGroup = false;
			if (self::$cache['groupsdis'])
			{
				foreach (self::$cache['groupsdis'] as $groupInfo)
				{
					if ($groupInfo['gmid'] != $groupmessageid AND $groupInfo['lastpostid'] != $groupmessageid)
					{
						// Skip this
						continue;
					}

					// Ensure we don't query needlessly
					$gotGroup = true;

					// Ensure this is set
					$discussionid = $discussionid ? $discussionid : $groupInfo['discussionid'];

					if (isset($groupInfo['replies']))
					{
						// We have replies in the info
						$commentCount = $groupInfo['replies'] + 1;
					}

					// Grab what we need to check for mod perms
					include_once(DIR . '/includes/functions_socialgroup.php');

					if ($groupInfo['moderation'] AND fetch_socialgroup_modperm('canmoderategroupmessages', $groupInfo))
					{
						// Comments under moderation
						$commentCount += $groupInfo['moderation'];
					}

					if ($groupInfo['deleted'] AND fetch_socialgroup_modperm('canviewdeleted', $groupInfo))
					{
						// Soft deleted comments
						$commentCount += $groupInfo['deleted'];
					}
					break;
				}
			}

			if (!$gotGroup)
			{
				// Get group message info
				$groupMessage = self::$db->generalQuery('
					SELECT *
					FROM $groupmessage
					WHERE gmid = ' . intval($groupmessageid) . '
				');

				// Count number of comments
				$numComments = self::$db->generalQuery('
					SELECT COUNT(*) AS comments
					FROM $groupmessage
					WHERE discussionid = ' . $groupMessage['discussionid'] . '
						AND state = \'visible\'
						AND dateline <= ' . $groupMessage['dateline'] . '
				');

				// Shorthand
				$commentCount = $numComments['comments'];
			}

			// Build the cache
			//self::$datastore->build('groupmessagepage.' . $discussionid . '.' . $groupmessageid . '.' . $vbulletin->userinfo['userid'], $commentCount);
		//}

		$perpage = intval(self::$config['gm_perpage']);
		return ($perpage ? ceil($commentCount / $perpage) : 1);
	}

	/**
	 * Fetches the group page info based on parameters
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getGroupPage($groupid, $groupmessageid)
	{
		//if (($numComments = self::$datastore->fetch('grouppage.' . $groupid . '.' . $groupmessageid)) === false)
		//{		
			// Get group message info
			$groupMessage = self::$db->generalQuery('
				SELECT *
				FROM $groupmessage
				WHERE gmid = ' . intval($groupmessageid) . '
					 AND groupid = ' . intval($groupid) . '
			');

			// Count number of comments
			$numComments = self::$db->generalQuery('
				SELECT COUNT(*) AS comments
				FROM $groupmessage
				WHERE groupid = ' . $groupid . '
					AND state = \'visible\'
					AND dateline >= ' . $groupMessage['dateline'] . '
			');

			// Build the cache
			self::$datastore->build('grouppage.' . $groupid . '.' . $groupmessageid, $numComments);
		//}

		$perpage = intval(self::$config['sg_perpage']);
		return ($perpage ? ceil($numComments / $perpage) : 1);
	}
	/**
	 * Fetches the user info based on parameters
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getUserInfo($userIds, $userNames = array())
	{
		if (!is_array($userIds))
		{
			// Ensure this is an array
			$userIds = array($userIds);
		}

		foreach ($userIds as $key => $id)
		{
			if (($info = self::$datastore->fetch('userinfo.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			self::$cache['userinfo'][$id] = $info;

			// We had this cached, cache it internally too
			self::$cache['username'][strtolower($info['username'])] = $info;

			if (self::$datastore->fetch('usernames.' . strtolower($info['username'])) === false)
			{
				// Build the cache
				self::$datastore->build('usernames.' . strtolower($info['username']), $info);
			}
		}

		foreach ($userIds as $key => &$userId)
		{
			if (isset(self::$cache['userinfo'][$userId]))
			{
				// We don't need this
				unset($userIds[$key]);
			}

			// Ensure these are all ints
			$userId = intval($userId);
		}

		if (!empty($userIds))
		{
			$info = self::$db->generalQuery('
				SELECT userid, username
				FROM $user
				WHERE userid IN (' . implode(',', $userIds) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				self::$datastore->build('userinfo.' . $arr['userid'], $arr);

				// Build the cache
				self::$datastore->build('usernames.' . strtolower($arr['username']), $arr);

				// Cache this info
				self::$cache['userinfo'][$arr['userid']] = self::$cache['usernames'][strtolower($arr['username'])] = $arr;
			}
		}

		if (!empty($userNames) AND strpos(self::$cache['rawurls']['memberprofile']['MemberProfile'], '%user_id%') !== false)
		{
			foreach ($userNames as $key => $userName)
			{
				if (($info = self::$datastore->fetch('usernames.' . strtolower($userName))) === false)
				{
					// We don't have this cached
					continue;
				}

				// Cache this info
				self::$cache['userinfo'][$info['userid']] = self::$cache['usernames'][strtolower($info['username'])] = $info;
			}

			foreach ($userNames as $key => &$userName)
			{
				if (isset(self::$cache['usernames'][strtolower($userName)]))
				{
					// We don't need this
					unset($userNames[$key]);
				}

				// Ensure these are all ints
				$userName = "'" . str_replace("'", "\\'", str_replace("\\", "\\\\", $userName)) . "'";
			}

			if (!empty($userNames))
			{
				$info = self::$db->generalQuery('
					SELECT userid, username
					FROM $user
					WHERE username IN (' . implode(',', $userNames) . ')
				', false);
				foreach ($info as $arr)
				{
					// Cache this info
					self::$cache['userinfo'][$arr['userid']] = self::$cache['usernames'][strtolower($arr['username'])] = $arr;
				}
			}
		}
	}

	/**
	 * Fetches the blog info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getBlogInfo($blogIds, $blogUser = false, $comment = false)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/blog.php');

		// Get blog info here
		return DBSEO_Rewrite_Blog::getInfo($blogIds, $blogUser, $comment);
	}

	/**
	 * Fetches the forum info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getForumInfo($forumIds)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/forum.php');

		// Get blog info here
		return DBSEO_Rewrite_Forum::getInfo($forumIds);
	}

	/**
	 * Fetches the post info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getPostInfo($postIds, $force = false)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/showpost.php');

		// Get blog info here
		return DBSEO_Rewrite_ShowPost::getInfo($postIds, $force);
	}

	/**
	 * Fetches the thread info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getThreadInfo($threadIds, $force = false)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/thread.php');

		// Get blog info here
		return DBSEO_Rewrite_Thread::getInfo($threadIds, $force);
	}

	/**
	 * Fetches the attachment info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getAttachmentInfo($attachmentIds)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/attachment.php');

		// Get blog info here
		return DBSEO_Rewrite_Attachment::getInfo($attachmentIds);
	}

	/**
	 * Fetches the blogattachment info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getBlogAttachmentInfo($attachmentIds)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/attachment.php');

		// Get blog info here
		return DBSEO_Rewrite_BlogAttachment::getInfo($attachmentIds);
	}

	/**
	 * Fetches the blogcategory info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getBlogCategoryInfo($blogCategoryIds)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/blog.php');

		// Get blog info here
		return DBSEO_Rewrite_BlogCategory::getInfo($blogCategoryIds);
	}

	/**
	 * Fetches the announcement info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getAnnouncementInfo($forumIds, $announcementIds = array())
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/announcement.php');

		// Get blog info here
		return DBSEO_Rewrite_Announcement::getInfo($forumIds, $announcementIds);
	}

	/**
	 * Fetches the poll info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getPollInfo($pollIds)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/poll.php');

		// Get blog info here
		return DBSEO_Rewrite_Poll::getInfo($pollIds);
	}

	/**
	 * Fetches the socialgroup info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getGroupInfo($groupIds)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/socialgroup.php');

		// Get blog info here
		return DBSEO_Rewrite_SocialGroup::getInfo($groupIds);
	}

	/**
	 * Fetches the post info based on parameters. Basically just a shorthand wrapper
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function getThreadPostInfo($postIds, $force = false)
	{
		$postInfo = array();

		if (!$postIds)
		{
			// We need at least one id
			return $postInfo;
		}

		if (!is_array($postIds))
		{
			// Ensure this is an array
			$postIds = array($postIds);
		}

		$queryList = array();
		foreach ($postIds as $key => $postId)
		{
			if (
				(
					!isset(self::$cache['post'][$postId]) AND 
					!isset(self::$cache['post'][$postId]['threadid'])
				) OR
				$force
			)
			{
				// Ensure this is done
				$queryList[$key] = intval($postId);

				// Reset the post cache
				self::$cache['post'][$postId] = array();
			}
		}

		if (empty($queryList))
		{
			// We need at least one id
			return $postInfo;
		}

		$info = self::$db->generalQuery('
			SELECT post.postid, thread.threadid, thread.title, post.dateline
			FROM $thread AS thread
			LEFT JOIN $post AS post USING(threadid)
			WHERE post.postid IN(' . implode(',', $queryList) . ')
		', false);
		foreach ($info as $arr)
		{
			if (in_array($arr['postid'], (array)self::$cache['_objectIds']['prepostthread_ids']))
			{
				if (function_exists('fetch_coventry'))
				{
					if ($coventry = fetch_coventry('string'))
					{
						$where = " AND post.userid NOT IN ($coventry)";
					}

					// Post order
					$postOrder = $vbulletin->userinfo['postorder'];
				}
				else
				{
					// Post order
					$postOrder = 0;
				}

				$info2 = self::$db->generalQuery('
					SELECT COUNT(*) AS preposts
					FROM $post AS post
					WHERE post.threadid = ' . $arr['threadid'] . '
						AND post.visible = 1
						AND post.dateline ' . ($postOrder == 0 ? '<= ' : '>= ') . $arr['dateline'] . '
						' . $where . '
				', true);

				// Add additional cache elements
				$arr['preposts'] = $info2['preposts'];
				$arr['prepostsproc'] = isset($postOrder);
			}

			self::$cache['post'][$arr['postid']] = $arr;
			self::$cache['_objectIds']['postthreads'][] = $arr['threadid'];
		}

		if (count($postIds) == 1)
		{
			// We have only one, return only one
			$postInfo = self::$cache['post'][$postIds[0]];
		}
		else
		{
			foreach ($postIds as $key => $postId)
			{
				// Create this array
				$postInfo[$postId] = self::$cache['post'][$postId];
			}
		}

		return $threadInfo;
	}

	/**
	 * Rewrites forum URL
	 *
	 * @param string $url
	 * 
	 * @return mixed
	 */
	public static function rewriteForumUrl($forumInfo, $force = false)
	{
		// Get the blog library
		require_once(DBSEO_CWD . '/dbtech/dbseo/includes/library/forum.php');

		// Get blog info here
		return DBSEO_Rewrite_Forum::rewriteUrl($forumInfo, $force);
	}

	/**
	 * Filters the selected tag
	 *
	 * @param string $tag
	 * 
	 * @return string
	 */
	public static function filterTag($tag)
	{
		// Ensure we have the correct data set
		$tag = str_replace(array('%2F', '+'), array('/', '%20'), $tag);

		if (!self::$config['dbtech_dbseo_filter_blogtag'])
		{
			// We aint filterin nothin
			return $tag;
		}

		// Do ze filtering
		return self::filterText(urldecode($tag), NULL, false);		
	}

	/**
	 * Grabs content ID from attachment info
	 *
	 * @param array $attachmentInfo
	 * 
	 * @return mixed
	 */
	public static function getContentId($attachmentInfo)
	{
		if (isset($attachmentInfo['albumid']))
		{
			return $attachmentInfo['albumid'];
		}
		else if (isset($attachmentInfo['groupid']))
		{
			return $attachmentInfo['groupid'];
		}
		else
		{
			return $attachmentInfo['contentid'];
		}
	}

	/**
	 * Grabs content ID from attachment info
	 *
	 * @param array $attachmentInfo
	 * 
	 * @return mixed
	 */
	public static function getContentType($attachmentInfo)
	{
		if ($attachmentInfo['albumid'])
		{
			// Album
			return 'album';
		}
		else if ($attachmentInfo['groupid'])
		{
			// Social group picture file
			return 'group';
		}
		else if (intval(self::$config['templateversion']) == 4)
		{
			if (!$attachmentInfo['contenttypeid'] OR $attachmentInfo['contenttypeid'] < 3)
			{
				// Forum attachment
				return 'forum';
			}

			// Get our content type
			return self::getContentTypeById($attachmentInfo['contenttypeid']);
		}

		// vB3 lands here
		return 'forum';
	}

	/**
	 * Grabs content type from ID
	 *
	 * @param integer $contenttypeid
	 * 
	 * @return string
	 */
	public static function getContentTypeById($contenttypeid)
	{
		if (($packages = self::$datastore->fetch('pgkinfo')) === false)
		{
			// We don't have this cached
			$packages = self::$db->generalQuery('SELECT * FROM $package');

			// Build the cache
			self::$datastore->build('pgkinfo', $packages);
		}

		if (($contenttypes = self::$datastore->fetch('contenttype')) === false)
		{
			// We don't have this cached
			$contenttypes = self::$db->generalQuery('SELECT * FROM $contenttype');

			// Build the cache
			self::$datastore->build('contenttype', $contenttypes);
		}

		$contentTypeIds = $packageLookup = array();
		foreach ($packages as $package)
		{
			// Store class by packageid
			$packageLookup[$package['packageid']] = $package['class'];
		}

		foreach ($contenttypes as $contenttype)
		{
			// Index this array properly
			$contentTypeIds[$packageLookup[$contenttype['packageid']] . '_' . $contenttype['class']] = $contenttype['contenttypeid'];
		}

		switch ($contenttypeid)
		{
			case $contentTypeIds['vBForum_Album']:
				return 'album';
				break;
				
			case $contentTypeIds['vBForum_SocialGroup']:
				return 'group';
				break;
				
			case $contentTypeIds['vBBlog_BlogEntry']:
				return 'blog';
				break;
				
			case $contentTypeIds['vBCms_Section']:
				return 'cms_section';
				break;
				
			case $contentTypeIds['vBCms_Article']:
				return 'cms_article';
				break;

			default:
				return 'forum';
				break;
		}
	}

	/**
	 * Updates the server environment variables based on the resolved URL
	 *
	 * @param string $url
	 * @param boolean $seo
	 * 
	 * @return mixed
	 */
	public static function updateEnvironment($url)
	{
		if (substr($url, 0, 1) == '/')
		{
			// We're trying for a directory
			$page = $url;
		}
		else
		{
			// Set the normalised page
			$page = DBSEO_URL_SCRIPT_PATH . $url;

			if (strpos($page, '../') !== false)
			{
				// We have directory navigation
				do
				{
					$ap = $page;
					$page = preg_replace('#/?[^/]*/\.\.#', '', $ap, 1);
				}
				while ($page != $ap);
			}
		}

		if (strpos($page, '?') !== false)
		{
			// We have a query
			@list($basepage, $query) = explode('?', $page, 2);
		}
		else
		{
			// No query needed
			$basepage = $page;
			$query = '';
		}

		$basepage = str_replace('//', '/', $basepage);
		preg_match('#([^/]+)$#', $basepage, $matches);

		// This is used in certain URL lookups
		$_SERVER['DBSEO_FILE'] = isset($matches[1]) ? $matches[1] : '';

		// Resolve the new page path
		$pagepath = /*dirname(DBSEO_CWD)*/ DBSEO_CWD . '/' . str_replace(DBSEO_URL_SCRIPT_PATH, '', $basepage);
		
		// Backup the current request URI
		$_SERVER['DBSEO_URI'] = $_SERVER['REQUEST_URI'];
		
		foreach (array(
			'REQUEST_URI' 		=> $page,
			'SCRIPT_NAME' 		=> $basepage,
			'PHP_SELF' 			=> $basepage,
			'PATH_INFO' 		=> $basepage,
			'SCRIPT_FILENAME' 	=> $pagepath,
			'PATH_TRANSLATED' 	=> $pagepath,
		) as $key => $val)
		{
			// Set us some variables
			$_SERVER[$key] = $_ENV[$key] = $GLOBALS[$key] = $val;
		}

		foreach (array(
			'REDIRECT_QUERY_STRING', 
			'REDIRECT_URL'
		) as $toUnset)
		{
			// Get rid of things we no longer want
			unset($_SERVER[$toUnset], $_ENV[$toUnset], $GLOBALS[$toUnset]);
		}

		// Set the arg query string
		$_SERVER['argv'][0] = $GLOBALS['argv'][0] = $query;

		if ($query)
		{
			// Set the various query string variables
			$_SERVER['QUERY_STRING'] = $_ENV['QUERY_STRING'] = $GLOBALS['QUERY_STRING'] = $query;
			
			// Parse the query into neat little key->value pairs with automagic urldecode
			parse_str($query, $params);

			foreach ($params as $name => $value)
			{
				if ($_REQUEST[$name])
				{
					// Already set
					continue;
				}
				
				// Set this now instead
				$_REQUEST[$name] = $_GET[$name] = $value;
			}
		}
	}

	/**
	 * Adds a canonical URL tag
	 *
	 * @param string $headinclude
	 * @param string $url
	 * @param boolean $validUrl
	 * 
	 * @return void
	 */
	public static function addCanonicalUrl(&$headinclude, $url, $validUrl = true)
	{
		if (defined('NOHEADER') AND NOHEADER)
		{
			// This isn't even.
			return;
		}

		if (!self::$config['dbtech_dbseo_add_canonical'])
		{
			// We're not adding this tag
			return;
		}

		if (strpos($headinclude, 'rel="canonical"') !== false)
		{
			// We already had a canonical tag
			return;
		}

		// Drop page from the URL
		$_url = preg_replace('#&page=$#', '', $url);

		if (!$_url)
		{
			// There was nothing left
			return;
		}

		//self::$config['dbtech_dbseo_canonical_strict'] AND 
		if (!$validUrl)
		{
			// Run the script stuff to create $rewrittenUrl using updateEnvironment settings
			if (!$rewrittenUrl = self::createAnyUrl())
			{
				// This is the wrong page
				return;
			}

			// Create full URL
			$fullRewrittenUrl = self::createFullUrl($rewrittenUrl, true) . (DBSEO_URL_QUERY ? '?' . DBSEO_URL_QUERY : '');

			if (DBSEO_URL != $fullRewrittenUrl)
			{
				// We only want to preserve existing queries
				$_SERVER['QUERY_STRING'] = DBSEO_URL_QUERY;

				// Redirec to the real URL
				self::safeRedirect($fullRewrittenUrl);
			}
		}

		// Create full URL
		$fullUrl = htmlspecialchars(self::createFullUrl($_url, true));

		// Preprend the canonical tag
		$headinclude = '<link rel="canonical" href="'. $fullUrl . '" />' . "\n" . $headinclude;
		
		// Update FB's Meta tags
		self::updateFBMeta($headinclude, 'url', $fullUrl);
	}

	/**
	 * Updates a FB Meta tag
	 *
	 * @param string $page
	 * @param string $meta
	 * @param string $content
	 * 
	 * @return void
	 */
	public static function updateFBMeta(&$page, $meta, $content)
	{
		if (!function_exists('is_facebookenabled') OR !is_facebookenabled())
		{
			// We don't have FB
			return;
		}

		// Update the page with the new meta content
		$page = preg_replace('#("og\:' . $meta . '"\s*content=")[^"]*#', '$1' . $content, $page);
	}	

	/**
	 * Converts a URL to a full URL
	 *
	 * @param string $url
	 * @param string $thisDomain
	 * 
	 * @return str
	 */
	public static function createFullUrl($url, $thisDomain = false)
	{
		if (strpos($url, '://') !== false)
		{
			// Already a full URL
			return $url;
		}

		if (substr($url, 0, 1) == '/')
		{
			// URL started with a slash
			$url = ($thisDomain ? DBSEO_URL_SCHEME . '://' . DBSEO_HTTP_HOST : preg_replace('#^(.*?//[^/]*).*#', '$1', self::$config['bburl'])) . $url;
		}
		else
		{
			// Ensure there's no trailing slashes in BB URL
			$url = preg_replace('#/$#', '', self::$config['bburl']) . '/' . $url;
		}

		return $url;
	}

	/**
	 * Handles getting / setting highlight parameters
	 *
	 * @param int $type
	 * 
	 * @return boolean
	 */
	public static function checkHighlight($isSetter)
	{
		if ($isSetter)
		{
			if (!isset($_COOKIE) OR !isset($_GET['highlight']))
			{
				// We don't have any highlights
				return false;
			}

			// Keep it secret! Keep it safe!
			setcookie(self::$config['_cookieprefix'] . 'dbseo_highlight', $_GET['highlight']);
			$_COOKIE[self::$config['_cookieprefix'] . 'dbseo_highlight'] = $_GET['highlight'];
		}
		else
		{
			if (!isset($_COOKIE[self::$config['_cookieprefix'] . 'dbseo_highlight']))
			{
				// We don't have a cookie
				return false;
			}

			// Was it secret? Was it safe?
			setcookie(self::$config['_cookieprefix'] . 'dbseo_highlight', '');
			$_GET['highlight'] = $_REQUEST['highlight'] = $_COOKIE[self::$config['_cookieprefix'] . 'dbseo_highlight'];
		}

		return true;
	}

	/**
	 * Execute a 301 redirect to a new URL
	 *
	 * @param int $type
	 * 
	 * @return mixed
	 */
	public static function safeRedirect($url, $paramsToUnset = array(), $unsetAllParams = false)
	{
		if (defined('VBSEO_UNREG_EXPIRED'))
		{
			// Compatibility with things like ForumRunner and other such items
			return;
		}

		$forumRoot = DBSEO_URL_BASE_PATH;
		if (substr($forumRoot, -1) != '/')
		{
			$forumRoot .= '/';
		}

		if (!$unsetAllParams)
		{
			$paramsToUnset = array_merge($paramsToUnset, array(
				'grab_output', 'goto', 
				'vbseourl', 'vbseorelpath', 'vbseoaddon', # Mostly for compat purposes
				'dbseourl', 'dbseorelpath', 'dbseoaddon',
			));

			if (self::$config['_stripsessionhash'])
			{
				// Strip the session hash
				$paramsToUnset[] = 's';
			}

			$queryString = $_SERVER['QUERY_STRING'];
			if (strpos($url, '?') !== false)
			{
				list($url, $queryString) = explode('?', $url);
			}

			// Grab the parameters from the query string if we have any
			$params = $queryString ? explode('&', str_replace('&amp;', '&', preg_replace('|#.*|', '', $queryString))) : array();
			
			$requestString = array();
			foreach ($params as $param)
			{
				list($key, $value) = explode('=', $param, 2);

				if (in_array($key, $paramsToUnset))
				{
					// Skip this param
					continue;
				}

				if (strpos($key, 'redirect_') !== false)
				{
					// Skip this param
					continue;
				}

				if (!$key AND !$value)
				{
					// Skip this param
					continue;
				}

				// Recreate the request string
				$requestString[] = $key . '=' . $value;
			}
		}

		if (substr($url, 0, 1) == '/')
		{
			$url = preg_replace('#(://[^/]*)(.*)$#', '$1', $forumRoot) . $url;    	
		}

		$fulluri = ((strpos($url, '://') !== false) ? '': $forumRoot) . $url;
		if ($requestString)
		{
			$fulluri = preg_replace('#^([^\#]*)#', '$1?' . implode('&', $requestString), $fulluri);
		}

		header("HTTP/1.x 301 Moved Permanently");
		$fulluri = preg_replace('#[\r\n]#', '', $fulluri);
		header("Location: $fulluri");
		exit();
	}

	/**
	 * Trap the output buffer for processing
	 *
	 * @param text $buffer
	 * @param boolean $isXML
	 * 
	 * @return mixed
	 */
	public static function outputHandler($buffer, $isXML = false)
	{
		if (!self::$config['_outputHandled'])
		{
			// Ensure this only runs once
			self::$config['_outputHandled'] = true;

			// Determine if we're passing XML
			$testXML = substr($buffer, 0, 5) == '<?xml';

			// Store whether this was an XML file
			self::$config['_isXML'] = $isXML OR $testXML;

			if (preg_match_all('#<[^>]*?[ \<\[]data="(.*?)"#is', $buffer, $matches))
			{
				foreach ($matches[1] as $match)
				{
					$match = html_entity_decode($match);
					$match = self::processContent($match);
					$buffer = str_replace($match, function_exists('htmlspecialchars_uni') ? htmlspecialchars_uni($match) : htmlspecialchars($match), $buffer);
				}
			}
			else
			{
				// Just process it as-is
				$buffer = self::processContent($buffer);
			}

			$buffer = preg_replace('#([\";]|\&quot\;)(images/)#s', '$1' . self::$config['bburl'] . '/$2', $buffer);
			if ($testXML AND (!function_exists('headers_list') OR preg_match('#\|content-length\:#i', implode('|', headers_list()))))
			{
				// We should add a content length
				@header('Content-Length: ' . strlen($buffer));
			}
		}
		return $buffer;
	}

	/**
	 * Processes the contents and rewrites URLs as needed
	 *
	 * @param text $content
	 * 
	 * @return mixed
	 */
	public static function processContent(&$content)
	{
		if (!self::$config['dbtech_dbseo_active'])
		{
			// We've disabled the mod
			return $content;
		}

		if ($_POST['do'] == 'editorswitch')
		{
			// We don't want to rewrite editor
			return $content;
		}

		// Flag that we've processed content
		self::$config['_process'] = true;

		// Turn off all error reporting
		//error_reporting(0);

		// Let the default error handler take over
		//restore_error_handler();

		global $vbulletin;

		$_noClean = array(
			'styleid' 	=> array(),
			'view' 		=> array('hybrid', 'threaded', 'linear'),
			'mode' 		=> array('hybrid', 'threaded', 'linear'),
		);

		if (THIS_SCRIPT == 'member')
		{
			// Don't 
			$_noClean['do'] = array('getinfo');
		}

		foreach ($_noClean as $key => $arr)
		{
			if (isset($_GET[$key]) AND (!$arr OR in_array($_GET[$key], $arr)))
			{
				// Redirect
				self::safeRedirect(DBSEO_REQURL, array_keys($_noClean));
			}
		}

		/*DBTECH_PRO_START*/
		if (DBSEO_SPIDER)
		{
			// Track ourselves a spider hit!
			self::trackSpider();
		}
		/*DBTECH_PRO_END*/

		// Back this up so we have something to work with
		$_content = $content;
		
		// Prefix it with the bburl
		$_prefix = (isset(self::$config['dbtech_dbseo_rewrite_texturls']) OR self::$config['_isXML']) ? '' : '[\'"](?:' . self::$config['_bburl'] . '/?)?';
		
		if (!self::$config['dbtech_dbseo_rewrite_texturls'] AND !self::$config['_isXML'])
		{
			preg_match_all('#(?:href=|src=|\.open\(|location=)["\'].*?["\']#is', $_content, $matches, PREG_PATTERN_ORDER);
			$_content = implode(" ", $matches[0]);
		}

		if (preg_match_all('#\bt-(\d+)\.html#', $_content, $matches))
		{
			// Archive urls
			self::$cache['_objectIds']['thread_ids'] = $matches[1];
		}

		if (self::$config['dbtech_dbseo_rewrite_memberprofile'])
		{
			if (preg_match_all('#member\.php\?[^"\']*?u(?:serid)?=(\d+)#', $_content, $matches))
			{
				// User ID link
				self::$cache['_objectIds']['user_ids'] = $matches[1];
			}
			
			if (preg_match_all('#member\.php\?[^"]*?username=([^"\']+)#', $_content, $matches))
			{
				// User name link
				self::$cache['_objectIds']['user_names'] = $matches[1];
			}
			
			if (preg_match_all('#converse\.php\?[^"\']*?u=(\d+)[^"\']*?u2=(\d+)#', $_content, $matches))
			{
				// Visitor message users
				self::$cache['_objectIds']['user_ids'] = is_array(self::$cache['_objectIds']['user_ids']) ? self::$cache['_objectIds']['user_ids'] : array();
				self::$cache['_objectIds']['user_ids'] = array_merge(self::$cache['_objectIds']['user_ids'], $matches[1], $matches[2]);
			}
			
			if (preg_match_all('#blog\.php\?[^"\']*?u=(\d+)#', $_content, $matches))
			{
				// Blogs
				self::$cache['_objectIds']['user_ids'] = is_array(self::$cache['_objectIds']['user_ids']) ? self::$cache['_objectIds']['user_ids'] : array();
				self::$cache['_objectIds']['user_ids'] = array_merge(self::$cache['_objectIds']['user_ids'], $matches[1]);
			}
			
			if (preg_match_all('#member\.php\?[^"]*?find=lastposter.*?t(?:hreadid)?=(\d+)#', $_content, $matches))
			{
				// Threads
				self::$cache['_objectIds']['thread_last'] = $matches[1];
				self::$cache['_objectIds']['thread_ids'] = is_array(self::$cache['_objectIds']['thread_ids']) ? self::$cache['_objectIds']['thread_ids'] : array();
				self::$cache['_objectIds']['thread_ids'] = array_merge(self::$cache['_objectIds']['thread_ids'], self::$cache['_objectIds']['thread_last']);
			}

			if (preg_match_all('#member\.php\?[^"]*?find=lastposter.*?f=(\d+)#', $_content, $matches))
			{
				// Last poster
				self::$cache['_objectIds']['forum_last'] = is_array(self::$cache['_objectIds']['forum_last']) ? self::$cache['_objectIds']['forum_last'] : array();				
				self::$cache['_objectIds']['forum_last'] = array_merge(self::$cache['_objectIds']['forum_last'], $matches[1]);
			}
		}

		if (self::$config['dbtech_dbseo_rewrite_album'])
		{
			if (preg_match_all('#album\.php\?[^"\']*?albumid=(\d+)#', $_content, $matches))
			{
				// Album url
				self::$cache['_objectIds']['album'] = $matches[1];
			}
			
			if (preg_match_all('#album\.php\?[^"\']*?' . self::$config['_pictureid'] . '=(\d+)#', $_content, $matches))
			{
				// Picture URL
				self::$cache['_objectIds'][self::$config['_picturestorage']] = is_array(self::$cache['_objectIds'][self::$config['_picturestorage']]) ? self::$cache['_objectIds'][self::$config['_picturestorage']] : array();				
				self::$cache['_objectIds'][self::$config['_picturestorage']] = array_merge(self::$cache['_objectIds'][self::$config['_picturestorage']], $matches[1]);
			}
		}

		if (self::$config['dbtech_dbseo_rewrite_socialgroup'] OR self::$config['dbtech_dbseo_rewrite_memberprofile'])
		{
			if (preg_match_all('#picture\.php\?[^"\']*?' . self::$config['_pictureid'] . '=(\d+)#', $_content, $matches))
			{
				// Picture URL
				self::$cache['_objectIds'][self::$config['_picturestorage']] = is_array(self::$cache['_objectIds'][self::$config['_picturestorage']]) ? self::$cache['_objectIds'][self::$config['_picturestorage']] : array();				
				self::$cache['_objectIds'][self::$config['_picturestorage']] = array_merge(self::$cache['_objectIds'][self::$config['_picturestorage']], $matches[1]);
			}
		}
		
		if (self::$config['dbtech_dbseo_rewrite_blog'])
		{
			if (preg_match_all('#blog\.php\?[^"]*?u=(\d+)#', $_content, $matches))
			{
				// Blog url
				self::$cache['_objectIds']['user_ids'] = is_array(self::$cache['_objectIds']['user_ids']) ? self::$cache['_objectIds']['user_ids'] : array();
				self::$cache['_objectIds']['user_ids'] = array_merge(self::$cache['_objectIds']['user_ids'],$matches[1]);
			}
			
			if (preg_match_all('#' . $_prefix . '(?:blog|entry)\.php\?[^"]*?b(?:logid)?=(\d+)#', $_content, $matches))
			{
				// Blog entry
				self::$cache['_objectIds']['blog_ids'] = $matches[1];
			}
			
			if (preg_match_all('#blog_attachment\.php\?[^"]*?attachmentid=(\d+)#', $_content, $matches))
			{
				// Blog attachment
				self::$cache['_objectIds']['blogatt_ids'] = $matches[1];
			}
			
			if (preg_match_all('#blog\.php\?[^"]*?cp=(\d+)#', $_content, $matches))
			{
				// Blog custom page
				self::$cache['_objectIds']['blogcustomblock'] = $matches[1];
			}
			
			if (preg_match_all('#blog\.php\?[^"]*?blogcategoryid=(\d+)#', $_content, $matches))
			{
				// Blog category id
				self::$cache['_objectIds']['blogcat_ids'] = $matches[1];
			}
		}

		if (self::$config['dbtech_dbseo_rewrite_announcement'] AND preg_match_all('#announcement\.php\?[^"]*?f(?:orumid)?=(\d+)#', $_content, $matches))
		{
			// Announcement
			self::$cache['_objectIds']['announcements'] = $matches[1];
		}

		if (self::$config['dbtech_dbseo_rewrite_socialgroup'])
		{
			if (preg_match_all('#group\.php\?[^"\']*?' . self::$config['_pictureid'] . '=(\d+)#', $_content, $matches))
			{
				// Picture url
				self::$cache['_objectIds'][self::$config['_picturestorage']] = is_array(self::$cache['_objectIds'][self::$config['_picturestorage']]) ? self::$cache['_objectIds'][self::$config['_picturestorage']] : array();
				self::$cache['_objectIds'][self::$config['_picturestorage']] = array_merge(self::$cache['_objectIds'][self::$config['_picturestorage']], $matches[1]);
			}
			
			if (preg_match_all('#group\.php\?[^"\']*?discussionid=(\d+)#', $_content, $matches))
			{
				// Discussion url
				self::$cache['_objectIds']['groupsdis'] = is_array(self::$cache['_objectIds']['groupsdis']) ? self::$cache['_objectIds']['groupsdis'] : array();
				self::$cache['_objectIds']['groupsdis'] = array_merge(self::$cache['_objectIds']['groupsdis'], $matches[1]);
			}
			
			if (preg_match_all('#group\.php\?[^"]*?groupid=(\d+)#', $_content, $matches))
			{
				// Group url
				self::$cache['_objectIds']['groups'] = $matches[1];
			}
			
			if (preg_match_all('#picture\.php\?[^"]*?groupid?=(\d+)#', $_content, $matches))
			{
				// Picture url
				self::$cache['_objectIds']['groups'] = is_array(self::$cache['_objectIds']['groups']) ? self::$cache['_objectIds']['groups'] : array();
				self::$cache['_objectIds']['groups'] = array_merge(self::$cache['_objectIds']['groups'], $matches[1]);
			}
		}

		if (self::$config['dbtech_dbseo_rewrite_attachment'] AND preg_match_all('#(?:attachment|group)\.php\?[^"]*?attachmentid=(\d+)#', $_content, $matches))
		{
			// Attachment url
			self::$cache['_objectIds']['attach'] = is_array(self::$cache['_objectIds']['attach']) ? self::$cache['_objectIds']['attach'] : array();
			self::$cache['_objectIds']['attach'] = array_merge(self::$cache['_objectIds']['attach'], $matches[1]);
		}

		if (self::$config['dbtech_dbseo_rewrite_thread'])
		{
			if (intval($vbulletin->versionnumber) == 4)
			{
				$showpostMatches = preg_match_all('#' . $_prefix . 'showthread\.php\?[^"]*?p(?:ostid|ost)?=(\d+)#', $_content, $matches);
			}
			else
			{
				$showpostMatches = preg_match_all('#' . $_prefix . 'showpost\.php\?[^"]*?p(?:ostid|ost)?=(\d+)#', $_content, $matches);
			}

			if ($showpostMatches)
			{
				// Thread url
				self::$cache['_objectIds']['postthread_ids'] = $matches[1];
				
				if (THIS_SCRIPT == 'showpost' AND !$_GET['postcount'])
				{
					// Also include showpost
					self::$cache['_objectIds']['prepostthread_ids'] = $matches[1];
				}
			}
		}

		if (self::$config['dbtech_dbseo_rewrite_poll'] AND preg_match_all('#poll\.php\?[^"]*?do=showresults&.*?pollid=(\d+)#', $_content, $matches))
		{
			// Poll url
			self::$cache['_objectIds']['poll_ids'] = $matches[1];
		}

		if (self::$config['dbtech_dbseo_rewrite_thread'] AND preg_match_all('#' . $_prefix . '(?:show|print)thread\.php\?[^"]*?t(?:hreadid)?=(\d+)#', $_content, $matches))
		{
			// Thread url
			self::$cache['_objectIds']['thread_ids'] = is_array(self::$cache['_objectIds']['thread_ids']) ? self::$cache['_objectIds']['thread_ids'] : array();
			self::$cache['_objectIds']['thread_ids'] = array_merge(self::$cache['_objectIds']['thread_ids'], $matches[1]);
		}

		if (self::$config['dbtech_dbseo_rewrite_avatar'] AND preg_match_all('#image\.php\?[^"]*?u=(\d+)#', $_content, $matches))
		{
			// Avatar url
			self::$cache['_objectIds']['user_ids'] = is_array(self::$cache['_objectIds']['user_ids']) ? self::$cache['_objectIds']['user_ids'] : array();
			self::$cache['_objectIds']['user_ids'] = array_merge(self::$cache['_objectIds']['user_ids'], $matches[1]);
		}

		if (self::$config['dbtech_dbseo_rewrite_cms'] AND intval(self::$config['templateversion']) == 4)
		{
			if (preg_match_all('#content\.php\?[^"]*?' . self::$config['route_requestvar'] . '=(\d+)#', $_content, $matches))
			{
				// Content url
				self::$cache['_objectIds']['cmscont'] = is_array(self::$cache['_objectIds']['cmscont']) ? self::$cache['_objectIds']['cmscont'] : array();
				self::$cache['_objectIds']['cmscont'] = array_merge(self::$cache['_objectIds']['cmscont'], $matches[1]);
			}

			if (preg_match_all('#list\.php\?[^"]*?' . self::$config['route_requestvar'] . '=category/(\d+)#', $_content, $matches))
			{
				// Cms category url
				self::$cache['_objectIds']['cms_cat'] = is_array(self::$cache['_objectIds']['cms_cat']) ? self::$cache['_objectIds']['cms_cat'] : array();
				self::$cache['_objectIds']['cms_cat'] = array_merge(self::$cache['_objectIds']['cms_cat'], $matches[1]);
			}
		}

		if (isset(self::$cache['_objectIds']['found_thread_ids']) AND is_array(self::$cache['_objectIds']['found_thread_ids']))
		{
			// Merge our found thread IDs
			self::$cache['_objectIds']['thread_ids'] = is_array(self::$cache['_objectIds']['thread_ids']) ? self::$cache['_objectIds']['thread_ids'] : array();
			self::$cache['_objectIds']['thread_ids'] = array_merge(self::$cache['_objectIds']['thread_ids'], self::$cache['_objectIds']['found_thread_ids']);
		}

		// Reset thread cache
		self::$cache['thread'] = array();

		if (
			isset(self::$cache['_objectIds']['announcements']) AND 
			count(self::$cache['_objectIds']['announcements'])
		)
		{
			// Grab announcements from cache
			self::getAnnouncementInfo(self::$cache['_objectIds']['announcements']);
		}

		if (
			isset(self::$cache['_objectIds']['poll_ids']) AND 
			count(self::$cache['_objectIds']['poll_ids'])
		)
		{
			// Grab poll stuff
			self::getPollInfo(self::$cache['_objectIds']['poll_ids']);
		}
		
		if (
			self::$config['dbtech_dbseo_rewrite_attachment'] AND 
			isset(self::$cache['_objectIds']['attach']) AND 
			count(self::$cache['_objectIds']['attach'])
		)
		{
			// Grab attachment cache
			self::getAttachmentInfo(self::$cache['_objectIds']['attach']);

			foreach (self::$cache['attachment'] as $attachment)
			{
				if ($attachment['contentid'] AND self::getContentType($attachment) == 'forum')
				{
					// Store post/thread ID
					self::$cache['_objectIds']['postthread_ids'][] = $attachment['contentid'];
				}
			}
		}

		if (
			is_array(self::$cache['_objectIds']['thread_ids']) OR 
			is_array(self::$cache['_objectIds']['postthreads'])
		)
		{
			self::$cache['_objectIds']['thread_ids'] = is_array(self::$cache['_objectIds']['thread_ids']) ? self::$cache['_objectIds']['thread_ids'] : array();
			self::$cache['_objectIds']['postthreads'] = is_array(self::$cache['_objectIds']['postthreads']) ? self::$cache['_objectIds']['postthreads'] : array();

			// Merge all thread ID arrays
			self::$cache['_objectIds']['thread_ids'] = array_merge(
				self::$cache['_objectIds']['thread_ids'], 
				self::$cache['_objectIds']['postthreads']
			);

			if (self::$cache['thread_pre'])
			{
				// Reset thread cache
				self::$cache['thread'] = array();

				$threadIds = array();
				foreach (self::$cache['thread_pre'] as $threadId => $thread)
				{
					// Shorthand
					$threadId = $thread['threadid'] ? $thread['threadid'] : $threadId;

					// Cache the thread info
					self::$cache['thread'][$threadId] = $thread;

					if (
						self::$cache['_objectIds']['thread_last'] AND 
						in_array($thread['threadid'], self::$cache['_objectIds']['thread_last'])
					)
					{
						// Store lastposter in username cache
						self::$cache['_objectIds']['user_names'][] = $thread['lastposter'];
					}
					
					if (
						!self::$config['dbtech_dbseo_rewrite_thread_prefix'] OR 
						self::$cache['thread'][$threadId]['prefixid']
					)
					{
						// We need to exclude this from further caching
						$threadIds[] = $threadId;
					}
				}

				// Remove this threadid from the cache
				self::$cache['_objectIds']['thread_ids'] = array_diff(self::$cache['_objectIds']['thread_ids'], $threadIds);
				
				foreach (self::$cache['thread'] as $threadId => $thread)
				{
					// Store userinfo cache
					self::$cache['_objectIds']['userinfo'][$thread['postuserid']] = array(
						'userid' 	=> $thread['postuserid'],
						'username' 	=> $thread['postusername']
					);

					if ($thread['pollid'])
					{
						// Set poll cache
						self::$cache['poll'][$thread['pollid']]['threadid'] = $threadId;
					}
				}
			}

			if (isset($GLOBALS['getlastpost']))
			{
				// Set lastpost info
				self::$cache['thread'][$GLOBALS['getlastpost']['threadid']] = $GLOBALS['getlastpost'];
			}

			if (count(self::$cache['_objectIds']['thread_ids']))
			{
				// Cache thread info
				self::getThreadInfo(self::$cache['_objectIds']['thread_ids']);
			}
		}

		if (self::$cache['_objectIds']['postthread_ids'])
		{
			// Cache thread and post info
			self::getThreadPostInfo(self::$cache['_objectIds']['postthread_ids'], true);
		}

		if (self::$cache['_objectIds']['prepostthread_ids'])
		{
			// Cache thread and post info
			self::getThreadPostInfo(self::$cache['_objectIds']['prepostthread_ids'], true);
		}

		if (self::$config['dbtech_dbseo_rewrite_socialgroup'])
		{
			// Ensure this is an array
			self::$cache['_objectIds']['groups'] 	= is_array(self::$cache['_objectIds']['groups']) 	? self::$cache['_objectIds']['groups'] 	: array();
			self::$cache['socialgroup'] 			= is_array(self::$cache['socialgroup']) 			? self::$cache['socialgroup'] 			: array();

			if (is_array($GLOBALS['group']) AND $GLOBALS['group']['groupid'])
			{
				// Store the global social group information if available
				self::$cache['socialgroup'][$GLOBALS['group']['groupid']] = $GLOBALS['group'];
			}

			// Get social group discussion info
			self::getObjectInfo('groupsdis', self::$cache['_objectIds']['groupsdis']);

			foreach ((array)self::$cache['socialgroupdiscussion'] as $socialGroupDiscussion)
			{
				// Store social group ID
				self::$cache['_objectIds']['groups'][] = $socialGroupDiscussion['groupid'];
			}

			// Remove any already cached groups
			self::$cache['_objectIds']['groups'] = array_diff(self::$cache['_objectIds']['groups'], array_keys(self::$cache['socialgroup']));
			
			// Get social group info
			self::getGroupInfo(self::$cache['_objectIds']['groups']);
			
			foreach (self::$cache['socialgroup'] as $socialGroup)
			{
				// Cache social group category ID
				self::$cache['socialgroupcategory'][$socialGroup['socialgroupcategoryid']] = array(
					'categoryid' 	=> $socialGroup['socialgroupcategoryid'],
					'title' 		=> $socialGroup['categoryname'],
				);
			}

			if ($GLOBALS['discussion'])
			{
				// Cache social group discussion info
				self::$cache['socialgroupdiscussion'][$GLOBALS['discussion']['discussionid']] = $GLOBALS['discussion'];
			}
			
			if (isset($vbulletin) AND isset($vbulletin->sg_category_cloud))
			{
				foreach ($vbulletin->sg_category_cloud as $socialGroupCategory)
				{
					// Cache social group category info
					self::$cache['socialgroupcategory'][$socialGroupCategory['categoryid']] = $socialGroupCategory;
				}
			}
		}

		if (self::$config['dbtech_dbseo_rewrite_blog'])
		{
			// Ensure this is an array
			self::$cache['_objectIds']['blogcat_ids'] 	= is_array(self::$cache['_objectIds']['blogcat_ids']) 	? self::$cache['_objectIds']['blogcat_ids'] 	: array();
			self::$cache['battach'] 					= is_array(self::$cache['battach']) 					? self::$cache['battach'] 						: array();
			self::$cache['blogcategory'] 				= is_array(self::$cache['blogcategory']) 				? self::$cache['blogcategory'] 					: array();

			foreach ((array)$GLOBALS['postattach'] as $attachment)
			{
				if (!is_array($attachment))
				{
					// Not an array, skip this
					continue;
				}

				if ($attachmentId = $attachment['attachmentid'])
				{
					// Overwrite attachment array
					$attachment = array($attachmentId => $attachment);
				}

				foreach ($attachment as $attachmentId => $att)
				{
					// Set blog attachment cache
					self::$cache['battach'][$attachmentId] = $att;
				}
			}

			if (self::$cache['_objectIds']['blogatt_ids'])
			{
				// Get blog attachment cache
				self::getBlogAttachmentInfo(self::$cache['_objectIds']['blogatt_ids']);
			}

			foreach (self::$cache['battach'] as $blogAttachment)
			{
				// Store blog IDs to cache
				self::$cache['_objectIds']['blog_ids'][] = $blogAttachment['blogid'];
			}

			if (is_array($GLOBALS['blog']) AND $GLOBALS['blog']['blogid'] AND $GLOBALS['blog']['userid'])
			{
				// We have blog info in the global scope
				self::$cache['blog'][$GLOBALS['blog']['blogid']] = $GLOBALS['blog'];
			}

			if (self::$cache['_objectIds']['blog_ids'])
			{
				// Get blog info
				self::getBlogInfo(self::$cache['_objectIds']['blog_ids']);
			}

			if (isset($vbulletin->vbblog['categorycache']))
			{
				foreach ($vbulletin->vbblog['categorycache'] as $categories)
				{
					if (!is_array($categories))
					{
						// Error prevention
						continue;
					}

					foreach ($categories as $categoryId => $category)
					{
						// Set blog category cache
						self::$cache['blogcategory'][$categoryId] = $category;
					}
				}
			}

			$blogCategories = (array)($GLOBALS['vblog_categories'] ? $GLOBALS['vblog_categories'] : $GLOBALS['categories']);
			foreach ($blogCategories as $categories)
			{
				if (!is_array($categories))
				{
					// Error prevention
					continue;
				}

				foreach ($categories as $categoryId => $category)
				{
					if (!isset($category['blogcategoryid']))
					{
						// Error prevention
						continue;
					}

					// Set blog category cache
					self::$cache['blogcategory'][$category['blogcategoryid']] = $category;
				}
			}

			// Ensure we don't attempt to re-cache 
			self::$cache['_objectIds']['blogcat_ids'] = array_diff(self::$cache['_objectIds']['blogcat_ids'], array_keys(self::$cache['blogcategory']));
			
			if (self::$cache['_objectIds']['blogcat_ids'])
			{
				// Get blog category cache
				self::getBlogCategoryInfo(self::$cache['_objectIds']['blogcat_ids']);
			}

			if (isset(self::$cache['blog']) AND is_array(self::$cache['blog']))
			{
				foreach (self::$cache['blog'] as $blog)
				{
					// Extract user IDs from blog
					self::$cache['_objectIds']['user_ids'][] = $blog['userid'];
				}
			}

			// Grab custom blog blocks
			self::getObjectInfo('blogcustomblock', self::$cache['_objectIds']['blogcustomblock']);
		}

		if (!(intval(self::$config['templateversion']) == 4) AND is_array($GLOBALS['pictureinfo']))
		{
			self::$cache[self::$config['_picturestorage']][$GLOBALS['pictureinfo'][self::$config['_pictureid']]] = $GLOBALS['pictureinfo'];
		}

		// Get user picture storage info
		self::getObjectInfo(self::$config['_picturestorage'], self::$cache['_objectIds'][self::$config['_picturestorage']]);

		if (self::$config['dbtech_dbseo_rewrite_cms'] AND intval(self::$config['templateversion']) == 4)
		{
			// We need to grab CMS content cache
			self::getObjectInfo('cmscont', self::$cache['_objectIds']['cmscont']);

			// We need to grab CMS Category cache
			self::getObjectInfo('cms_cat', self::$cache['_objectIds']['cms_cat']);
		}

		if (
			(
				self::$config['dbtech_dbseo_rewrite_memberprofile'] OR 
				self::$config['dbtech_dbseo_rewrite_album'] OR 
				self::$config['dbtech_dbseo_rewrite_avatar'] OR 
				self::$config['dbtech_dbseo_rewrite_blog']
			) AND
			(
				!empty(self::$cache['_objectIds']['user_ids']) OR 
				!empty(self::$cache['_objectIds']['user_names'])
			)
		)
		{
			// Ensure this is an array
			self::$cache['_objectIds']['user_names'] 	= is_array(self::$cache['_objectIds']['user_names']) 	? self::$cache['_objectIds']['user_names'] 	: array();
			self::$cache['username'] 					= is_array(self::$cache['username']) 					? self::$cache['username'] 					: array();

			foreach ((array)self::$cache[self::$config['_picturestorage']] as $picture)
			{
				if (self::getContentType($picture) == 'album')
				{
					// Grab content info from attach info
					self::$cache['_objectIds']['album'][] = self::getContentId($picture);
				}
			}

			if (is_array($GLOBALS['albuminfo']))
			{
				// Store album cache from album info
				self::$cache['album'][$GLOBALS['albuminfo']['albumid']] = $GLOBALS['albuminfo'];
			}

			// Get album info to cache
			self::getObjectInfo('album');
			
			foreach ((array)self::$cache['album'] as $picture)
			{
				// Get additional users to cache
				self::$cache['_objectIds']['user_ids'][] = $picture['userid'];
			}

			// Ensure we only have unique user ids
			$userids = array_unique(self::$cache['_objectIds']['user_ids']);
			
			if (isset($GLOBALS['newuserid']))
			{
				// Pre-cache user info
				self::$cache['_objectIds']['userinfo'][$GLOBALS['newuserid']] = array(
					'userid' 	=> $GLOBALS['newuserid'],
					'username' 	=> $GLOBALS['newusername']
				);
			}

			foreach ((array)self::$cache['_objectIds']['userinfo'] as $userId => $userInfo)
			{
				if ($userId AND $userName = strip_tags($userInfo['username']))
				{
					// Pre-cache user info
					self::$cache['user'][$userId] = self::$cache['username'][strtolower($userName)] = array(
						'userid' 	=> $userId,
						'username' 	=> $userName
					);
				}
			}

			foreach ((array)self::$cache['post'] as $postId => $post)
			{
				if (isset($post['postuserid']) AND $userId = $post['postuserid'] AND $userName = $post['postusername'])
				{
					// Pre-cache user info
					self::$cache['user'][$userId] = self::$cache['username'][strtolower($userName)] = array(
						'userid' 	=> $userId,
						'username' 	=> $userName
					);
				}
			}

			// Ensure we only cache users we haven't cached before
			$userids = array_diff($userids, array_keys(self::$cache['user'] ? self::$cache['user'] : array()));

			// Ensure we only cache users we haven't cached before
			self::$cache['_objectIds']['user_names'] = array_diff(self::$cache['_objectIds']['user_names'], array_keys(self::$cache['username']));
			
			if (!empty($userids) OR !empty(self::$cache['_objectIds']['user_names']))
			{
				// Cache the user info
				self::getUserInfo($userids, self::$cache['_objectIds']['user_names']);
			}
			else
			{
				for ($i = 0; $i < count($userids); $i++)
				{
					// Just cache userids
					self::$cache['user'][$userids[$i]] = array(
						'userid' => $userids[$i]
					);
				}
			}
		}

		self::$config['_baseHref'] = false;
		if (
			DBSEO_BASEDEPTH AND 
			preg_match('#<base href="([^\"]*)#i', $content, $matches) AND 
			preg_replace('#/[^/]*$#', '', $matches[1]) == self::$config['_bburl']
		)
		{
			// We need to update the base href later on
			self::$config['_baseHref'] = true;
		}

		if (DBSEO_BASEDEPTH AND self::$config['_preprocessed'])
		{
			$_baseUrl = self::$config['_bburl']; 
			if (strpos($_baseUrl, DBSEO_HTTP_HOST) === false AND (self::$config['dbtech_dbseo_custom_cms'] OR self::$config['dbtech_dbseo_custom_blog']))
			{
				// Overwrite the base URL
				$_baseUrl = DBSEO_URL_SCHEME . '://' . DBSEO_HTTP_HOST;
			}

			// Replace the base url
			$content = preg_replace('#<head>#i', "$0\n" . '<base href="' . $_baseUrl . '/" /><!--[if IE]></base><![endif]-->', $content, 1);
		}

		if (isset(self::$config['dbtech_dbseo_rewrite_texturls']))
		{
			// Replace text urls in content
			$content = preg_replace_callback(
				'#(' . str_replace('tps\:','tps?\:', preg_quote(self::$config['_bburl'], '#')) . '/?)([^<\]\[\"\)\s]*)#is', 
				array('DBSEO', 'replaceTextUrls'), 
				$content
			);
		}

		if (self::$config['_isXML'])
		{
			// Replace text urls in XML
			$content = preg_replace_callback( 
				'#(<link>(?:\<\!\[CDATA\[)?)([^<\]]*)#is',
				array('DBSEO', 'replaceTextUrls'), 
				$content
			);
		}

		// Do main content replacements
		$content2 = preg_replace_callback( 
			'#(value="(?:\[.*?\])?)(' . preg_quote(self::$config['_bburl'], '#') . '/?)([^<\]\[\"\)\s]*)#is',
			array('DBSEO', 'replaceMainContent'), 
			$content
		);

		// Ensure we only overwrite content if it's valid
		$content = $content2 ? $content2 : $content;

		if (!isset(self::$config['dbtech_dbseo_rewrite_texturls']))
		{
			$content = preg_replace_callback(
				'#(<(?:a|span|iframe|form|script|link|img|meta)([^>]*?)(?:href|src|action|url|\.open|\.location|content)\s*[=\(]\s*["\'])([^"\'>\)]*)(.*?[\>])([^<]*)(</a>)?#is',
				array('DBSEO', 'replaceTags'), 
				$content
			);

			if (!self::$config['_inAjax'] AND isset(self::$cache['urlReplace']))
			{
				// Start fresh!
				unset(self::$cache['urlReplace']);
			}

			if (strpos($_SERVER['REQUEST_URI'], 'printthread.php') !== false)
			{
				// Ensure we're doing this
				self::$config['_rewritePrintThread'] = 1;

				// Replace the text URLs again
				$content = preg_replace_callback(
					'#(\([^\)]*?(?:http://)?[^\)]*?)(' . preg_quote(self::$config['_bburl'], '#') . '/[^<\)]*)#is',
					array('DBSEO', 'replaceTextUrls'), 
					$content
				);
			}
		}

		if (self::$config['dbtech_dbseo_analytics_account'] AND self::$config['dbtech_dbseo_analytics_track_external'] AND self::isThreaded())
		{
			// Ensure we track external urls
			$content = preg_replace_callback(
				'#^(\s*pd\[\d+\] = )\'(.+)$#m', 
				array('DBSEO', 'replaceExternalLinks'), 
				$content
			);
		}

		if (intval(self::$config['templateversion']) != 4)
		{
			// Shorthand
			$threadIconUrl = 'images/misc/navbits_finallink';

			if (self::$config['dbtech_dbseo_rewrite_navbullet'] AND strpos($content, $threadIconUrl) !== false)
			{
				if (preg_match('#' . $threadIconUrl . '(_...)?[^>]+?alt="([^"]+)"#', $content, $matches))
				{
					// Parse the thread icon url
					$currentDir = $matches[1];
					$currentAlt = $matches[2];
				}

				// Shorthand
				$threadIconFullUrl = $threadIconUrl . $currentDir . '.gif';

				if ($GLOBALS['tempusagecache']['FORUMDISPLAY'])
				{
					if (preg_match('#f=(\d+)#', $_SERVER['REQUEST_URI'], $matches))
					{
						// Grab our forum cache
						$forumcache = self::$db->fetchForumCache();

						$content = str_replace(
							$threadIconFullUrl,
							self::createUrl('NavBullet_NavBullet_Forum', array(
								'currentDir' 	=> $currentDir,
								'forumid' 		=> $matches[1]
							)),
							$content
						);
						$content = str_replace($currentAlt, str_replace('"', '&quot;', $forumcache[$matches[1]]['title']), $content);
					}
				}
				else if ($GLOBALS['tempusagecache']['SHOWTHREAD'])
				{
					// Ensure we top load this
					reset(self::$cache['thread']);

					// Extract this information
					list($threadid, $threadInfo) = each(self::$cache['thread']);
					
					$content = str_replace(
						array(
							$threadIconFullUrl,
							$currentAlt
						),
						array(
							self::createUrl('NavBullet_NavBullet_Thread', array(
								'currentDir' 	=> $currentDir,
								'threadid' 		=> $threadid,
								'forumid' 		=> $threadInfo['forumid'],
							)),
							str_replace('"', '&quot;', $threadInfo['title'])
						), 
						$content
					);
				}
			}
		}

		// Init some important things
		$_keyWords = $_description = '';
		$_appendDescription = false;

		switch (THIS_SCRIPT)
		{
			case 'showpost':
				if (self::$config['dbtech_dbseo_metadescription_posts'] AND $GLOBALS['postinfo']['postid'])
				{
					// Append rather than overwrite
					$_appendDescription = true;

					// Set post info
					$_description = 'Post ' . $GLOBALS['postinfo']['postid'] . ' - ';
				}
				break;

			case 'tags':
				if (self::$config['dbtech_dbseo_metadescription_threads'] AND $GLOBALS['tag'])
				{
					// Description from tags
					global $vbphrase;
					$_description = construct_phrase($vbphrase['threads_tagged_with_x'], $GLOBALS['tag']['tagtext']);
				}
				break;

			case 'member':
				if (self::$config['dbtech_dbseo_metadescription_memberprofiles'])
				{
					global $userinfo, $vbulletin;

					// Shorthand
					$usergroup = $vbulletin->usergroupcache[$userinfo['displaygroupid'] ? $userinfo['displaygroupid'] : $userinfo['usergroupid']];

					// Do description replacements
					$_description = preg_replace_callback(
						'#\[user_field_(\d+)\]#i', 
						array('DBSEO', 'replaceProfileMeta'), 
						str_replace(
							array('[username]', '[usertitle]', '[bb_title]', '[bbtitle]'),
							array($userinfo['username'], ($usergroup['usertitle'] ? $usergroup['usertitle'] : $usergroup['title']), self::$config['bbtitle'], self::$config['bbtitle']),
							stripslashes(self::$config['dbtech_dbseo_metadescription_memberprofiles_content'])
						)
					);
				}

				if (self::$config['dbtech_dbseo_metakeyword_memberprofiles'])
				{
					// Set the keywords to the username
					$_keyWords = self::$cache['userinfo'][intval($_GET['u'])]['username'];
				}
				break;
			
			case 'forumdisplay':
				if (self::$config['dbtech_dbseo_metadescription_forums'] OR self::$config['dbtech_dbseo_metakeyword_forums'])
				{
					// We need to do a few common things for this
					global $vbphrase;

					// Shorthand
					$forumcache = self::$db->fetchForumCache();
					$forumInfo = $forumcache[$_GET['f']];
				}

				if (self::$config['dbtech_dbseo_metadescription_forums'])
				{
					// Forum description
					$_description = unhtmlspecialchars($forumInfo['title']) . ($_GET['page'] > 1 ? ', ' . construct_phrase($vbphrase['page_x'], intval($_GET['page'])) : '') . (isset($forumInfo['description']) ? ' - ' . unhtmlspecialchars($forumInfo['description']) : '');
				}

				if (self::$config['dbtech_dbseo_metakeyword_forums'])
				{
					// Forum keywords
					$_keyWords = preg_replace('#[^a-zA-Z0-9_\x80-\xff]+#', ',', unhtmlspecialchars($forumInfo['title']));
				}
				break;
			
			case 'showpost':
			case 'showthread':
				if (self::$config[THIS_SCRIPT == 'showpost' ? 'dbtech_dbseo_metadescription_posts' : 'dbtech_dbseo_metadescription_threads'])
				{
					if ($GLOBALS['postbits'])
					{
						preg_match('#<!--\s*message\s*-->(.*?)<!--\s*/\s*message\s*-->#s', $GLOBALS['postbits'], $matches);
						if (!$matches)
						{
							$_searchVal = intval(self::$config['templateversion']) == 4 ? '</blockquote>' : '</div>';
							if (strpos($GLOBALS['postbits'], $_searchVal) !== false)
							{
								// Try another match
								preg_match('#post_message_[^>]*?\>(.*?)' . $_searchVal . '#s', $GLOBALS['postbits'], $matches);
							}
						}

						// Extract the description
						$_description = trim(preg_replace(array(
							'#<!--.*?-->#s', 
							'#<div>Originally Posted by.*?</div>#',
							'#<script.*?\>.*?</script>#is',
							'#(<.*?\>)+#s'
						), '', str_replace('>' . $vbphrase['quote'] . ':<', '', $matches[1])));
					}
				}

				if (self::$config[THIS_SCRIPT == 'showpost' ? 'dbtech_dbseo_keywords_posts' : 'dbtech_dbseo_metakeyword_threads'] AND $GLOBALS['threadinfo']['title'])
				{
					// Do keyword replacements
					preg_match_all('#([a-zA-Z0-9_\x80-\xff]+)#s', $GLOBALS['threadinfo']['title'], $matches);
					$_keyWords = implode(',', $matches[1]);
				}
				break;
			
			case 'blog':
			case 'entry':
				if (self::$config['dbtech_dbseo_metadescription_blogs'] AND $GLOBALS['blog']['message'])
				{
					// Description replacements
					$_description = trim(preg_replace('#(<.*?>)+#s', ' ', $GLOBALS['blog']['message']));
				}

				if (self::$config['dbtech_dbseo_metakeyword_blogs'] AND $GLOBALS['blog']['title'])
				{
					// Blog keywords from title
					preg_match_all('#([a-zA-Z0-9_\x80-\xff]+)#s', $GLOBALS['blog']['title'], $matches);
					$_keyWords = implode(',', $matches[1]);
				}
				break;
		}

		($hook = vBulletinHook::fetch_hook('dbtech_dbseo_process_content_meta')) ? eval($hook) : false;

		if ($_keyWords)
		{
			// Get rid of any HTML in the keywords
			$_keyWords = strip_tags($_keyWords);
			
			if (self::$config['dbtech_dbseo_stopwordlist'])
			{
				// Get rid of stopwords
				$_keyWords = preg_replace('#,?\b(' . self::$config['dbtech_dbseo_stopwordlist'] . ')\b#i', '', $_keyWords);
			}

			if (strlen($_keyWords) > self::$config['dbtech_dbseo_metadescription_length'])
			{
				// Keywords were too long
				$_keyWords = self::subStr($_keyWords, self::$config['dbtech_dbseo_metadescription_length']);
			}

			// Ensure things are quoted properly
			$_keyWords = str_replace(array('$','\\'), array('\$','\\\\'), $_keyWords);

			// Now finally replace the content
			$content = preg_replace('#(<meta name="keywords".*?content=)"#is', '$1"' . $_keyWords . ',', $content);
		}

		if ($_description)
		{
			// We had a description!
			$_description = preg_replace('#[\s\"]+#s', ' ', strip_tags($_description));
			
			if (strlen($_description) > self::$config['dbtech_dbseo_metadescription_length'])
			{
				// Shorten the description
				$_description = self::subStr($_description, self::$config['dbtech_dbseo_metadescription_length']);
			}

			// Ensure this is quoted properly
			$_description = str_replace(array('$','\\','"'), array('\$','\\\\','&quot;'), $_description);

			// Do FB Meta replacements
			self::updateFBMeta($content, 'description', $_description);
			
			// Do normal Meta replacements
			$content = preg_replace('#(<meta name="description".*?content=)"' . ($_appendDescription ? '' : '[^"]*') . '#is', '$1"' . $_description, $content);
		}

		// GOOGLE ANALYTICS
		if (self::$config['dbtech_dbseo_analytics_active'] AND self::$config['dbtech_dbseo_analytics_account'] AND !self::$config['dbtech_dbseo_rewrite_texturls'] AND !self::$config['_inAjax'])
		{
			// Init some important variables
			$trackingUrl = '';
			$trackingOptions = array();

			if (THIS_SCRIPT == 'search' AND $_REQUEST['do'] == 'showresults')
			{
				$searchQuery = $GLOBALS['display']['highlight'] ? implode(' ', $GLOBALS['display']['highlight']) : '';
				if (!$searchQuery AND is_object($GLOBALS['results']))
				{
					// Grab the keywords from the results
					$searchQuery = $GLOBALS['results']->get_criteria()->get_raw_keywords();
				}

				if ($searchQuery)
				{
					// Use tracking url
					$trackingUrl = 'search.php?q=' . urlencode($searchQuery);
				}
			}

			if (self::$config['dbtech_dbseo_analytics_universal'])
			{
				$content = str_replace('</head>', "
					<script type=\"text/javascript\">
					<!--
						(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
						(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
						m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
						})(window,document,'script','//www.google-analytics.com/analytics.js','ga');

						ga('create', '" . addslashes(self::$config['dbtech_dbseo_analytics_account']) . "'" . (self::$config['cookiedomain'] ? ", '" . addslashes(self::$config['cookiedomain']) . "'" : '') . ");

						ga('send', 'pageview'" . ($trackingUrl ? ",'$trackingUrl'" : "") . ");
					//-->
					</script>
				</head>", $content);
			}
			else
			{
				// Add two tracking elements
				array_push($trackingOptions, "['_trackPageview'" . ($trackingUrl ? ",'$trackingUrl'" : "") . "]");

				// Add the account info
				array_unshift($trackingOptions, "['_setAccount', '" . addslashes(self::$config['dbtech_dbseo_analytics_account']) . "']");

				if (self::$config['cookiedomain'])
				{
					// Override domain name with cookie domain
					array_unshift($trackingOptions, "['_setDomainName', '" . addslashes(self::$config['cookiedomain']) . "']");
				}

				$content = str_replace('</head>', "
					<script type=\"text/javascript\">
					<!--
						var _gaq = _gaq || [];

						_gaq.push(" . implode(");\n\n_gaq.push(", $trackingOptions) . ");
						
						(function() {
							var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
							ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
							var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
						})();
					//-->
					</script>
				</head>", $content);
			}
		}
		// END GOOGLE ANALYTICS

		return $content;
	}

	/**
	 * Replace text urls
	 */
	protected static function replaceTextUrls($matches)
	{
		return self::replaceUrls($matches[1], $matches[2]);
	}

	/**
	 * Replace main content
	 */
	protected static function replaceMainContent($matches)
	{
		return stripslashes($matches[1]) . self::replaceUrls('', $matches[2] . $matches[3]);
	}

	/**
	 * Replace tags
	 */
	protected static function replaceTags($matches)
	{
		return self::replaceUrls($matches[1], $matches[3], $matches[2], $matches[4], $matches[5], $matches[6]);
	}

	/**
	 * Replace tags
	 */
	public static function urlDecodeCallback($matches)
	{
		return urldecode($matches[1]);
	}

	/**
	 * Replace thread IDs
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceThreadId($matches)
	{
		// Un-quote these
		$matches[1] = str_replace('\"', '"', $matches[1]);
		$matches[2] = str_replace('\"', '"', $matches[2]);

		// Store thread ID
		self::$cache['_objectIds']['found_thread_ids'][] = $matches[3];

		// Return parsed content
		return $matches[1] . "!" . $matches[3] . "!" . $matches[2];
	}

	/**
	 * Replace thread IDs
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceThreadIdAlt($matches)
	{
		// Un-quote these
		$matches[1] = str_replace('\"', '"', $matches[1]);
		$matches[2] = str_replace('\"', '"', $matches[2]);

		// Store thread ID
		self::$cache['_objectIds']['found_thread_ids'][] = $matches[3];

		// Return parsed content
		return $matches[1] . "!m" . $matches[3] . "!" . $matches[2];
	}

	/**
	 * Replace post IDs
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replacePostId($matches)
	{
		// Un-quote these
		$matches[1] = str_replace('\"', '"', $matches[1]);
		$matches[2] = str_replace('\"', '"', $matches[2]);

		// Store thread ID
		self::$cache['_objectIds']['found_post_ids'][] = $matches[3];

		// Return parsed content
		return $matches[1] . "!p" . $matches[3] . "!" . $matches[2];
	}

	/**
	 * Replace profile meta tag
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceProfileMeta($matches)
	{
		// Return parsed content
		return self::$cache['userinfo']['field' . $matches[1]];
	}

	/**
	 * Replace external links in threaded mode
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceExternalLinks($matches)
	{
		if (self::$config['dbtech_dbseo_analytics_universal'])
		{
			// Return parsed content
			return $matches[1] . "'" . preg_replace_callback(
				'#(ga\(\'send\', \'event\', .*?\))#i', 
				array('DBSEO', 'replaceExternalLinks2'), 
				str_replace('\\"', '"', $matches[2])
			);
		}
		else
		{
			// Return parsed content
			return $matches[1] . "'" . preg_replace_callback(
				'#(_gaq\.push\(\[.*?\])#i', 
				array('DBSEO', 'replaceExternalLinks2'), 
				str_replace('\\"', '"', $matches[2])
			);
		}
	}

	/**
	 * Replace external links in threaded mode (step 2)
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceExternalLinks2($matches)
	{
		// Return parsed content
		return str_replace("'", "\\'", $matches[1]);
	}

	/**
	 * Replaces unicode characters
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceUnicodeChars($matches)
	{
		// Return parsed content
		return "'&#" . hexdec($matches[1]). ";'";
	}

	/**
	 * Replaces other characters
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceCharacters($matches)
	{
		// Return parsed content
		return chr($matches[1]);
	}

	/**
	 * Replaces keywords
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function replaceStopWords($matches)
	{
		// Return parsed content
		return (((self::$cache['keyWordCount2']--) <= 0) ? $matches[1] : '');
	}

	/**
	 * Replace post IDs
	 *
	 * @param string $matches
	 * 
	 * @return string
	 */
	public static function getReverseFormat($format)
	{
		return preg_replace(array(
			'#%thread_id%#',
			'#%thread_page%#',
			'#%post_id%#',
			'#%post_count%#',
			'#%[a-z_]+_id%#',
			'#%[a-z_]+_path%#',
			'#%[a-z_]+%#'
		), array(
			'(\d+)',
			'\d+',
			'(\d+)',
			'\d+',
			'\d+',
			'.+',
			'[^/]+'
		), preg_quote($format, '#'));
	}

	/**
	 * Replace urls
	 *
	 * @param string $urlPrefix
	 * @param string $url
	 * @param string $urlAttributes
	 * @param string $urlSuffix
	 * @param string $inTag
	 * @param string $closeTag
	 * 
	 * @return mixed
	 */
	public static function replaceIds($content)
	{
		if (self::$config['dbtech_dbseo_rewrite_texturls'] OR !self::$config['dbtech_dbseo_linktitles'])
		{
			// We're not doing this
			return $content;
		}

		// Shorthand
		$_fullBbUrl = preg_quote(self::$config['_bburl'] . '/', '#');

		// Replace post ID
		$content = preg_replace_callback(
			'#(href=")(' . $_fullBbUrl . self::getReverseFormat(self::$config['dbtech_dbseo_rewrite_rule_showpost']) . '[^/"]*")#is', 
			array('DBSEO', 'replacePostId'), 
			$content
		);

		// Replace showpost ID
		$content = preg_replace_callback(
			'#(href=")(' . $_fullBbUrl . 'showpost\.php\?[^"]*?p(?:ostid)?=(\d+)[^/"]*")#is', 
			array('DBSEO', 'replacePostId'), 
			$content
		);

		// Paged & SEO'd thread
		$content = preg_replace_callback(
			'#(href=")(' . $_fullBbUrl .  self::getReverseFormat(self::$config['dbtech_dbseo_rewrite_rule_thread_page']) . '[^/"]*")#is', 
			array('DBSEO', 'replaceThreadIdAlt'), 
			$content
		);

		// SEO'd Thread
		$content = preg_replace_callback(
			'#(href=")(' . $_fullBbUrl .  self::getReverseFormat(self::$config['dbtech_dbseo_rewrite_rule_thread']) . '[^/"]*")#is', 
			array('DBSEO', 'replaceThreadId'), 
			$content
		);

		// Normal thread
		$content = preg_replace_callback(
			'#(href=")(' . $_fullBbUrl . '(?:show|print)thread\.php\?[^"]*?t(?:hreadid)?=(\d+)[^/"]*")#is', 
			array('DBSEO', 'replaceThreadId'), 
			$content
		);

		return $content;
	}

	/**
	 * Appends template code
	 *
	 * @param string $templateName
	 * @param string $templateCode
	 * 
	 * @return mixed
	 */
	public static function addTemplateCode($templateName, $templateCode)
	{
		global $vbulletin;

		if (!isset($vbulletin->templatecache[$templateName]))
		{
			// Template didn't exist
			return false;
		}

		if (intval(self::$config['templateversion']) == 4 AND strpos($vbulletin->templatecache[$templateName], 'final_rendered') !== false)
		{
			// We have $final_rendered
			$templateCode .= ';';
		}
		else
		{
			// Inject it in the middle of a template
			$templateCode = '" . ((' . $templateCode . ') ? "" : "") . "';
		}
		
		// Shorthand
		$template =& $vbulletin->templatecache[$templateName];
		
		// Back this up
		$_template = $template;

		// Append the template
		$template .= $templateCode;

		return ($template != $_template);
	}

	/**
	 * Transforms external links into titled links
	 *
	 * @param string $message
	 * @param boolean $cleanRedirect
	 * 
	 * @return mixed
	 */
	public static function linkExternalTitles($message, $cleanRedirect = true)
	{
		if (!$message)
		{
			// Just in case
			return $message;
		}
		
		if ($cleanRedirect)
		{
			// We need to urldecode the redirect links
			$message = preg_replace_callback(
				'#' . preg_quote(self::$config['_bburl'] . '/redirect-to/?redirect=', '#') . '([^"\]\[]*)#is', 
				array('DBSEO', 'urlDecodeCallback'),
				$message
			);
		}

		if (!self::$config['dbtech_dbseo_linktitles_external'])
		{
			// We're not doing this
			return $message;
		}

		preg_match_all('#\[url=?\"?(.*?)\"?\](.+?)\[\/url\]#is', $message, $matches);
		for ($i = 0; $i < count($matches[0]); $i++)
		{
			if (self::$config['dbtech_dbseo_linktitles_external_limit'] AND ($i + 1) > self::$config['dbtech_dbseo_linktitles_external_limit'])
			{
				// No more of this nonsense
				break;
			}
			
			// Shorthand
			$urlLink = trim($matches[1][$i]);
			$urlContents = trim($matches[2][$i]);

			if ($urlLink AND strpos($urlContents, $urlLink) === false)
			{
				// We didn't have the same URL link as the contents, i.e. not [url=link]link[/url]
				continue;
			}

			if (strpos($urlContents, '://') === false)
			{
				// Ensure we add http if required
				$urlContents = 'http://' . $urlContents;
			}

			if (!$urlLink)
			{
				// We didn't have a link, i.e. [url]link[/url]
				$urlLink = $urlContents;
			}
			
			if (!(preg_match('#^http://#', $urlContents) AND (
				!self::$config['dbtech_dbseo_linktitles_external_blacklist'] OR 
				!preg_match('#' . self::$config['dbtech_dbseo_linktitles_external_blacklist'] . '#i', $urlContents)
			)))
			{
				// We're done here
				continue;
			}

			// Shorthand
			$_fullBbUrl = preg_quote(self::$config['_bburl'] . '/', '#');
			
			// Check if it's an internal link
			$_isMatch = false;
			$_isMatch |= preg_match('#' . $_fullBbUrl . self::getReverseFormat(self::$config['dbtech_dbseo_rewrite_rule_showpost']) . 		'#is', $urlContents);
			$_isMatch |= preg_match('#' . $_fullBbUrl . self::getReverseFormat(self::$config['dbtech_dbseo_rewrite_rule_thread_page']) . 	'#is', $urlContents);
			$_isMatch |= preg_match('#' . $_fullBbUrl . self::getReverseFormat(self::$config['dbtech_dbseo_rewrite_rule_thread']) . 		'#is', $urlContents);
			$_isMatch &= !preg_match('#' . $_fullBbUrl . self::getReverseFormat(self::$config['dbtech_dbseo_rewrite_rule_cmsentry']) . 		'#is', $urlContents);

			if ($_isMatch)
			{
				// We're done here
				continue;
			}

			// Ensure this doesn't error
			$page = array('header' => '', 'content' => '');

			if ($ch = curl_init())
			{
				// This was not a supported internal URL				
				curl_setopt($ch, CURLOPT_URL, $urlContents);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_VERBOSE, 1);
				curl_setopt($ch, CURLOPT_HEADER, 1);
				list($page['header'], $page['content']) = explode("\r\n\r\n", curl_exec($ch), 2);
			}

			if (!$page['content'])
			{
				// We're done here
				continue;
			}

			// In case we had a bogus title tag inside comments
			$page['content'] = preg_replace('#<!--.*?-->#s', '', $page['content']);

			// Grab our title tags
			preg_match('#<title[^>]*?\>(.+?)</title[^>]*?\>#is', $page['content'], $titleMatches);

			if (!preg_match('#content-type:.*?charset=([a-z0-9\-]+)#is', $page['headers'], $charsets))
			{
				// Try matching against meta
				preg_match('#<meta[^>]*?content-type[^>]*?charset=(.+?)\"#is', $page['content'], $charsets);
			}

			if ($charsets[1])
			{
				// Decode HTML entities
				$titleMatches[1] = @html_entity_decode($titleMatches[1], ENT_COMPAT, $charsets[1]);
			}

			if (function_exists('to_charset'))
			{
				// Convert the string to our current charset
				$titleMatches[1] = to_charset($titleMatches[1], $charsets[1]);
			}
			else
			{
				// Convert the string to our current charset
				$titleMatches[1] = self::_toCharset($titleMatches[1], $charsets[1]);
			}
	
			if ($_tmp = preg_replace_callback(
				'#&\#x([a-fA-F0-9]{2});#u', 
				array('DBSEO', 'replaceUnicodeChars'), 
				$titleMatches[1]
			))
			{
				// Unicode decodings
				$titleMatches[1] = $_tmp;
			}

			if ($_tmp = preg_replace_callback(
				'#&\#([0-9]{3});#u', 
				array('DBSEO', 'replaceCharacters'), 
				$titleMatches[1]
			))
			{
				// More decodings
				$titleMatches[1] = $_tmp;
			}

			// Do final preparations on the page title
			$pageTitle = self::subStr(str_replace(array('&rsaquo;', '&trade;'), array(chr(155), chr(153)), strtr(trim(preg_replace('#\s+#', ' ', $titleMatches[1])), array_flip(get_html_translation_table(HTML_ENTITIES)))), 250);
			
			if ($pageTitle AND $pageTitle != self::$config['bbtitle'])
			{
				// The page title was not the forum title
				$message = str_replace($matches[0][$i], '[url=' . $urlContents . ']' . $pageTitle . '[/url]', $message);
			}
		}

		return $message;
	}

	/**
	 * Replace urls
	 *
	 * @param string $urlPrefix
	 * @param string $url
	 * @param string $urlAttributes
	 * @param string $urlSuffix
	 * @param string $inTag
	 * @param string $closeTag
	 * 
	 * @return mixed
	 */
	public static function replaceUrls($urlPrefix, $url, $urlAttributes = '', $urlSuffix = '', $inTag = '', $closeTag = '')
	{
		global $session, $vbulletin;

		if (strpos($url, 'javascript:') !== false OR preg_match('#\<(script|base|form)+#i', $urlPrefix))
		{
			if ($url AND strpos($url, 'javascript:') === false AND strpos($url, '://') === false AND substr($url, 0, 2) !== '//')
			{
				$url = self::$config['_bburl'] . '/' . $url;
			}
			return $urlPrefix . $url . $urlSuffix . $inTag . $closeTag;
		}

		if (strpos($urlPrefix, 'meta') !== false AND strpos($urlPrefix, 'og:url') === false)
		{
			return $urlPrefix . $url . $urlSuffix . $inTag . $closeTag;
		}

		if ($url AND $url != 'javascript:' AND strpos($url, '://') === false AND substr($url, 0, 2) !== '//' AND preg_match('#\<(link)+#i', $urlPrefix))
		{
			$url = self::$config['_bburl'] . '/' . $url;
		}

		foreach (array('urlPrefix', 'urlSuffix', 'inTag', 'closeTag') as $var)
		{
			// Clean the variable
			$$var = str_replace('\"', '"', $$var);
		}

		$parseString = '';
		if (substr($urlPrefix, -1) == '"' AND (($quotePos = strpos($urlSuffix, '"')) > 0) AND substr($urlSuffix, 0, 1) != "'")
		{
			// Clean up the URL and the suffix
			$url .= substr($urlSuffix, 0, $quotePos);
			$urlSuffix = substr($urlSuffix, $quotePos);
		}

		if (
			(
				substr($urlPrefix, -1) != substr($urlSuffix, 0, 1) AND 
				$urlSuffix AND 
				!self::$config['dbtech_dbseo_rewrite_texturls'] AND 
				!self::$config['_rewritePrintThread'] AND 
				!self::$config['_isXML']
			) OR 
			strpos($url, 'data:') !== false
		)
		{
			// We're not rewriting this URL
			return $urlPrefix . $url . $urlSuffix . $inTag . $closeTag;
		}

		//vbstop($url, false, false);
		//echo "<pre>$url</pre>";

		if (
			strpos($urlPrefix,'rel="novbseo"') !== false OR   # Compatibility
			strpos($urlPrefix,'rel=\'novbseo\'') !== false OR # Compatibility
			strpos($urlPrefix,'rel="nodbseo"') !== false OR 
			strpos($urlPrefix,'rel=\'nodbseo\'') !== false
		)
		{
			// Return the URL as-is
			return preg_replace('#rel=[\'"]no(v|d)bseo[\'"]#', '', $urlPrefix) . $url . $urlSuffix . $inTag . $closeTag;
		}

		if (substr($url, 0, 1) == '#')
		{
			// Simple marker
			return $urlPrefix . ((DBSEO_BASEDEPTH AND self::$config['_preprocessed']) ? htmlspecialchars(DBSEO_URL_CLEAN) : '' ) . $url . $urlSuffix . $inTag . $closeTag;
		}

		if (self::$config['dbtech_dbseo_linktitles'] AND substr($url, 0, 1) == '!')
		{
			// Detect the markers
			preg_match('#^\!([mp])?(\d+)#', $url, $matches);

			// Get rid of the marker
			$url = preg_replace('#^\![mp]?\d+\!#', '', $url);

			// Shorthand some information
			$threadId = $matches[1] == 'p' ? self::$cache['post'][$matches[2]]['threadid'] : $matches[2];
			$threadTitle = self::$cache['thread'][$threadId]['title'];
			
			if ($matches[1] != 'p' AND strpos($url, 'showthread.php') === false)
			{
				// Attempt to create thread title
				if ($matches[1] == 'm')
				{
					$threadUrl = self::createUrl('Thread_Thread_Page', array('threadid' => $threadId, 'page' => '#m#'));
					if (!preg_match('#' . str_replace('\\#m\\#', '\d+', preg_quote($threadUrl,'#')) . '#', $url))
					{
						// We failed :(
						$threadTitle = '';
					}
				}
				else
				{
					$threadUrl = self::createUrl('Thread_Thread', array('threadid' => $threadId));
					if (!$threadUrl OR strpos($url, $threadUrl) == false)
					{
						// We failed :(
						$threadTitle = '';
					}
				}
			}

			if ($threadTitle AND $inTag != $threadTitle)
			{
				switch (self::$config['dbtech_dbseo_linktitles'])
				{
					case 1:
						// Title attribute
						$urlPrefix = preg_replace('#(<a\s)#is', '\\1title="' . htmlspecialchars($threadTitle) . '" ', $urlPrefix);
						break;

					case 2:
						// Append
						$inTag = $inTag . " ($threadTitle)";
						break;

					case 3:
						if (preg_match('#^http:#', $inTag))
						{
							// Overwrite
							$inTag = $threadTitle;
						}
						break;
				}
			}
		}

		// Set the quote character
		$quoteChar = substr($urlPrefix, -1);
		$quoteChar = $quoteChar == '"' ? '"' : "'";

		// Prepare the "nofollow" attribute
		$_noFollow = 'rel=' . $quoteChar . 'nofollow' . $quoteChar;

		if (
			substr($url, 0, 7) == 'mailto:' OR
			substr($url, 0, 11) == 'javascript:' OR
			(
				($cproto = 1) AND 
				strpos($url, '://') !== false AND 
				strpos($url, DBSEO_HTTP_HOST) === false AND 
				strpos($url, self::$config['_bburl']) === false 
			)
		)
		{
			// Match the host name and check whether we're an external url
			preg_match('#(?:www\.)?(.+)$#', DBSEO_HTTP_HOST, $matches);
			$_isExternal = !preg_match('#^[^/]*://(www\.)?' . preg_quote($matches[1], '#') . '#', $url);
			
			if ($_isExternal)
			{
				// We have an external URL
				if (
					(
						self::$config['dbtech_dbseo_externalurls'] AND (
							!self::$config['dbtech_dbseo_externalurls_whitelist'] OR 
							!preg_match('#' . self::$config['dbtech_dbseo_externalurls_whitelist'] . '#i', $url)
						)
					) OR (
						!self::$config['dbtech_dbseo_externalurls'] AND (
							self::$config['dbtech_dbseo_externalurls_whitelist'] AND 
							preg_match('#' . self::$config['dbtech_dbseo_externalurls_whitelist'] . '#i', $url)
						)
					) AND
					strpos($urlPrefix . $urlAttributes . $urlSuffix, 'rel=') === false
				)
				{
					// We didn't have a rel tag already, add one
					$urlPrefix = preg_replace('#(<a\s)#is', '\\1' . $_noFollow . ' ', $urlPrefix);
				}

				// Add external link tracking
				self::trackExternalLink($urlPrefix, $url, $urlSuffix, (substr($inTag, 0, 5) == 'Visit' ? 'onmouseup' : ''));
			}

			if (
				self::$config['dbtech_dbseo_externalurls_anonymise'] AND 
				(
					strpos($url, 'http://') !== false OR 
					strpos($url, 'https://') !== false
				) AND 
				in_array(THIS_SCRIPT, array('showthread', 'printthread', 'showpost', 'forumdisplay', 'newreply')) AND 
				strpos($urlPrefix,'<a') !== false AND
				strpos($urlPrefix, 'href') !== false AND
				$_isExternal
			)
			{
				// Ensure external URLs have redirects
				$url = self::$config['_bburl'] . '/redirect-to/?redirect=' . urlencode(strtr($url, array_flip(get_html_translation_table(HTML_ENTITIES))));
			}

			// We don't need to do anything else to this URL
			return $urlPrefix . $url . $urlSuffix . $inTag . $closeTag;
		}

		// Init some important variables
		$url = preg_replace('#([^:]/)/+#', '$1', $url);
		$_urlPlace = $_urlAppend = $_urlParameters = $_cmsUrlAppend = '';

		if (strpos($url, '?') !== false)
		{
			// We have a query parameter
			list($_urlScript, $_urlAppend) = explode('?', $url, 2);
		}
		else
		{
			// Just go with the flat URL
			$_urlScript = $url;
		}

		if ($_urlAppend AND substr($_urlAppend, 0, 1) == '?')
		{
			// We gotta remove the question mark
			$_urlAppend = substr($_urlAppend, 1);
		}

		if (strpos($_urlScript, '#') !== false AND preg_match('#^(.+[^\&])\#(.*)$#', $_urlScript, $matches))
		{
			// The URL script had an anchor
			$_urlScript = $matches[1];
			$_urlPlace = $matches[2];
		}
		else if (strpos($_urlAppend, '#') !== false AND preg_match('#^(.+[^\&])\#(.*)$#', $_urlAppend, $matches))
		{
			// URL append had an anchor
			$_urlParameters = $matches[1];
			$_urlPlace = $matches[2];
		}
		else
		{
			// Just set the parameters
			$_urlParameters = $_urlAppend;
		}

		if (preg_match('#^([^/]*?\.php)/(.+)$#', $_urlScript, $matches))
		{
			$_cmsUrlAppend = $matches[2];
			$_urlScript  = $matches[1];
		}

		// Match base and directory
		preg_match('#^(.*?)([^/]*)$#', $_urlScript, $matches);
		$_baseScript = $matches[2];
		$_dirScript = $matches[1];

		// Detect whether we're in a vB directory
		$_isvBDir = (
			(
				!$_dirScript AND (
					!DBSEO_BASEDEPTH OR
					self::$config['_inAjax'] OR
					self::$config['_baseHref'] OR 
					self::$config['_preprocessed']
				)
			) OR 
			strcasecmp($_dirScript, DBSEO_URL_SCRIPT_PATH) == 0 OR 
			strcasecmp($_dirScript, DBSEO_URL_BASE_PATH) == 0 OR 
			strcasecmp($_dirScript, self::$config['_bburl'] . '/') == 0 OR 
			strcasecmp(str_replace('www.', '', $_dirScript), DBSEO_URL_BASE_PATH) == 0
		);

		// Detect whether this is a vB URL
		$_isvBUrl = strpos($_urlScript, self::$config['_bburl']) !== false;

		// Shorthand
		$_topUrl = self::$config['_bburl'] . '/';
		
		if ($_urlParameters == '&amp;')
		{
			// We don't want urlencoded url parameters
			$_urlParameters = '';
		}

		// Ensure we don't have any encoded parameters
		$_preparedUrlParameters = str_replace('&amp;', '&', $_urlParameters) . '&';

		// Init some important variables
		$_seoParameters = $_stringParameters = array();
		$_position1 = $i = 0;
		$_position2 = -1;

		/*
		while (
			($_position2 + 1) > strlen($_preparedUrlParameters) AND
			($_position2 = strpos($_preparedUrlParameters, '&', ($_position2 + 1)) !== false) AND 
			$i++ < 20
		)
		*/

		while (
			(
				($_position2 = strpos($_preparedUrlParameters, '&', $_position2 + 1)) !== false
			) AND 
			(
				$i++ < 20
			)
		)
		{
			// Fetch this parameter alone
			$_subParameter = substr($_preparedUrlParameters, $_position1, $_position2 - $_position1);

			if (substr($_preparedUrlParameters, $_position2, 1) == '#')
			{
				// We don't need anything in the anchor
				continue;
			}

			// Continue from where we left off
			$_position1 = $_position2 + 1;

			$value = '';
			if (strpos($_subParameter, '=') !== false)
			{
				// Grab the key/value pair
				list($key, $value) = explode('=', $_subParameter, 2);
			}
			else
			{
				// Singular parameter
				$key = $_subParameter;
			}

			$key = trim($key);
			if ($key)
			{
				// Grab the decoded value
				$decodedValue = urldecode($value);

				if (strpos($decodedValue, 'http:') !== false AND substr($decodedValue, 0, strlen(self::$config['_bburl'])) == self::$config['_bburl'])
				{
					// Replace URLs in the value
					$decodedValue = self::replaceUrls('', $decodedValue);

					// Re-encode this
					$value = urlencode($decodedValue);
				}

				// Parameters to pass to the URL generation function
				$_seoParameters[$key] = $value;
				$_stringParameters[] = array($key, $value);
			}
		}

		/*
		if ($_dirScript == self::$config['avatarurl'] . '/')
		{
			// Grab our info for custom avatars
			preg_match('#avatar(\d+)_(\d+).gif#', $_baseScript, $avatarUser);

			// Set parameters
			$_seoParameters['u'] = $avatarUser[1];
			//$_seoParameters['type'] = 'profile';
			$_stringParameters[] = array('u', $avatarUser[1]);
			//$_stringParameters[] = array('type', 'profile');

			// Override some stuff
			$_isvBDir = true;
			$_baseScript = 'image.php';
			$_dirScript = '';
		}
		*/

		if (THIS_SCRIPT == 'online')
		{
			if (strpos($urlPrefix, 'alt=') !== false)
			{
				// Replace alt attribute
				$urlPrefix = preg_replace_callback(
					'#(alt=")([^"]+)#is', 
					array('DBSEO', 'replaceTextUrls'), 
					$urlPrefix
				);
			}

			if (strpos($urlSuffix, 'alt=') !== false)
			{
				// Replace alt attribute
				$urlSuffix = preg_replace_callback(
					'#(alt=")([^"]+)#is', 
					array('DBSEO', 'replaceTextUrls'), 
					$urlSuffix
				);
			}
		}

		if (!isset($session) AND isset($vbulletin->session))
		{
			$session = $vbulletin->session->vars;
		}

		$_appendSession = '';
		if (isset($_seoParameters['s']))
		{
			if (!(
				$vbulletin->userinfo['userid'] AND (
					(
						isset($session) AND 
						in_array($_seoParameters['s'], $session) AND 
						self::$config['_stripsessionhash']
					) OR 
					isset(self::$config['dbtech_dbseo_rewrite_texturls'])
				)
			))
			{
				// We want to put the session back
				$_appendSession = 's=' . $_seoParameters['s'];
			}

			// Ensure we don't include this in the parameters
			unset($_seoParameters['s']);

			// Also replace them from this string
			$_urlParameters = preg_replace('#^s=[\da-z]+(&amp;|&)*#', '', $_urlParameters);
			$_urlParameters = preg_replace('#(&amp;|&)s=[\da-z]+#', '', $_urlParameters);

			if (count($_stringParameters) == 1 AND $_stringParameters[0][0] == 's')
			{
				// Reset this array, since we're stripping session
				$_stringParameters = array();
			}
		}

		$_removeAllParameters = false;

		if (count($_seoParameters) == 1 AND preg_match('#^[ft]-#', $_urlParameters))
		{
			// We had only one parameter, and it was forumid or threadid
			$parseString = $_urlAppend;
			$_topUrl = '';
			$_removeAllParameters = true;
		}

		$nofollow = $follow = $_preventProcessing = false;
		if (isset($_seoParameters['threadid']))
		{
			// Ensure we set this shorthand
			$_seoParameters['t'] = $_seoParameters['threadid'];
		}

		if (!$_removeAllParameters AND $_isvBDir)
		{
			do
			{
				if ($_baseScript == 'index.php' AND !$_urlParameters AND self::$config['dbtech_dbseo_force_directory_index'])
				{
					$_urlScript = ((isset(self::$config['dbtech_dbseo_rewrite_texturls']) OR THIS_SCRIPT == 'sendmessage2') ? '' : $_topUrl) . self::$config['_homepage'];
					$_preventProcessing = true;
					break;
				}

				// Detect file name
				$_strippedFileName = preg_replace('/[^\w\.-]/i', '', $_baseScript);

				// Detect script alias if any exists
				$_strippedFileName = isset(self::$cache['_scriptAlias'][$_strippedFileName]) ? self::$cache['_scriptAlias'][$_strippedFileName] : $_strippedFileName;

				if (!$_strippedFileName OR !file_exists(DBSEO_CWD . '/dbtech/dbseo/includes/scripts/' . $_strippedFileName))
				{
					// Git oot.
					$_preventProcessing = true;
					if (isset($_seoParameters['do']) AND $_seoParameters['do'] == 'getdaily')
					{
						// We're in the getdaily script
						$follow = true;
					}
					break;
				}

				// Include the file
				require_once(DBSEO_CWD . '/dbtech/dbseo/includes/scripts/' . $_strippedFileName);

				$class = 'DBSEO_Script_' . ucfirst(pathinfo($_strippedFileName, PATHINFO_FILENAME));

				if (!class_exists($class) OR !method_exists($class, 'replaceUrls'))
				{
					// Git oot.
					$_preventProcessing = true;
					if (isset($_seoParameters['do']) AND $_seoParameters['do'] == 'getdaily')
					{
						// We're in the getdaily script
						$follow = true;
					}
					break;
				}

				$newUrl = call_user_func_array(array($class, 'replaceUrls'), array(
					&$_preventProcessing,
					&$_seoParameters,
					&$urlPrefix,
					&$url, 
					&$urlSuffix,
					&$inTag,
					&$_urlScript,
					&$_urlPlace,
					&$_urlParameters,
					&$_removeAllParameters,
					&$_cmsUrlAppend,
					&$nofollow,
					&$follow
				));
				if ($newUrl == '-')
				{
					// We had a different result
					return $newUrl;
				}
				else if ($newUrl === false)
				{
					// We returned boolean false
					break;
				}
			}
			while (false);
		}
		else
		{
			$_preventProcessing = true;
		}

		if ($_preventProcessing)
		{
			// Duplicate this to ensure we don't overwrite the original URL
			$customUrl = $_urlScript;

			if ($_isvBDir)
			{
				// Set the custom URL if we're in vB
				$customUrl = (!$_baseScript OR strpos($_urlScript, $_baseScript) !== false) ? $_baseScript : preg_replace('#^(.*?)([^/]*)$#', '$2', $_urlScript);
			}

			if ($newUrl = self::parseCustomRewrites($customUrl . ($_urlParameters ? '?' . $_urlParameters : ''), $nofollow))
			{
				// We had a new URL
				$_urlScript = $newUrl;
				$_removeAllParameters = true;

				if ($_isvBDir)
				{
					// Don't block any further processing
					$_preventProcessing = false;
				}
			}
		}

		if (
			(
				$_preventProcessing AND 
				!$_isvBDir AND 
				(
					stripos(DBSEO_BASE, DBSEO_URL_SCRIPT_PATH) === false OR substr($url, 0, 1) == '/' OR !(
						DBSEO_BASEDEPTH AND 
						self::$config['_preprocessed']
					)
				)
			) OR 
			(
				isset(self::$config['dbtech_dbseo_rewrite_texturls']) OR THIS_SCRIPT == 'sendmessage'
			) OR 
			(
				!self::$config['_preprocessed'] AND 
				!$_isvBUrl AND 
				!DBSEO_BASEDEPTH AND 
				THIS_SCRIPT != 'index'
			)
		)
		{
			// Reset top URL
			$_topUrl = '';
		}

		// Shorthand
		$ampersand = (isset(self::$config['dbtech_dbseo_rewrite_texturls']) AND !isset(self::$config['dbtech_dbseo_rewrite_external'])) ? '&' : '&amp;';

		if (!$_removeAllParameters)
		{
			if (
				($_urlParameters AND substr($_urlParameters, 0, 1) == '=') OR 
				strpos($_urlParameters, '=') === false
			)
			{
				// Suffix the URL parameters
				$parseString .= $_urlParameters;
			}
			else if (
				(strpos($_urlParameters, '=') === false OR substr($_urlParameters, 0, 1) == '=') AND
				count($_stringParameters) == 1 
			)
			{
				// We had only one string param
				$parseString .= $_stringParameters[0][0];
			}
			else
			{
				for ($i = 0; $i < count($_stringParameters); $i++)
				{
					if (isset($_seoParameters[$_stringParameters[$i][0]]))
					{
						// We had this parameter, add it
						$parseString .= ($parseString ? $ampersand : '') . $_stringParameters[$i][0] . '=' . $_stringParameters[$i][1];
					}
				}
			}
		}
		else
		{
			// We're getting rid of all parameters
			unset($_seoParameters);
		}

		if ($_appendSession)
		{
			// We need to append our session
			$parseString .= ($parseString ? $ampersand : '') . $_appendSession;
		}

		if (
			substr($_urlScript, 0, 1) != '/' AND 
			strpos(substr($_urlScript, 3, 5), ':') === false
		)
		{
			// Overwrite the URL Script
			$_urlScript = ($urlPrefix ? $_topUrl : self::$config['_bburl'] . '/') .  $_urlScript;
		}

		// Set the new URL
		$newUrl = $_urlScript . ($parseString ? '?' . $parseString : '') . (($_urlPlace AND strpos($_urlScript, '#') === false) ? '#' . $_urlPlace : '');

		if ($follow)
		{
			// Get rid of noFollow from the prefix and the suffix
			$urlSuffix = str_replace($_noFollow, '', $urlSuffix);
			$urlPrefix = str_replace($_noFollow, '', $urlPrefix);
		}
		else if (
			($nofollow OR isset($_seoParameters['sort']) OR $_seoParameters) AND 
			strpos($urlPrefix . $urlAttributes . $urlSuffix, 'rel=') === false
		)
		{
			// Add the rel if needed
			$urlPrefix = preg_replace('#(<a\s)#is', '\\1' . $_noFollow . ' ', $urlPrefix);
		}

		if (self::$config['dbtech_dbseo_rewrite_texturls'] AND strpos($newUrl, 'http://') !== false AND strpos($urlPrefix, 'http://') !== false)
		{
			// Unset the prefix
			$urlPrefix = '';
		}

		if ($inTag AND $url == $inTag)
		{
			/// Set the final URL component
			$inTag = $newUrl;
		}

		// Reconstruct the URL!
		return $urlPrefix . $newUrl . $urlSuffix . $inTag . $closeTag;
	}

	/**
	 * Parse custom rewrite rules
	 */
	public static function parseCustomRewrites($_originalUrl, &$nofollow)
	{
		$newUrl = '';

		if (strpos($_originalUrl, '#') !== false)
		{
			// We have an anchor
			list($url, $anchor) = explode('#', $_originalUrl);
		}
		else
		{
			$url = $_originalUrl;
			$anchor = '';
		}

		// Create our custom URL with the anchor suffixed
		if (!$_newUrl = self::createUrl('Custom_CustomRewrite', $url))
		{
			// Return blank
			return $newUrl;
		}

		// Append anchor if we had it
		$_newUrl .= ($anchor ? '#' . $anchor : '');

		if ($_originalUrl == $_newUrl)
		{
			// Return blank
			return $newUrl;
		}

		// The URL was different
		$newUrl = $_newUrl;

		if (strpos($newUrl, '[NF]') !== false)
		{
			// We had noFollow tag
			$newUrl = str_replace('[NF]', '', $newUrl);

			// Ensure we append rel="nofollow"
			$nofollow = true;
		}
		
		return $newUrl;
	}

	/**
	 * Track external link
	 */
	public static function trackExternalLink(&$urlPrefix, $url, &$urlSuffix, $clickHandler = '')
	{
		if (!self::$config['dbtech_dbseo_analytics_active'] OR !self::$config['dbtech_dbseo_analytics_track_external'])
		{
			// We're not using GA
			return;
		}

		if (!$clickHandler)
		{
			// Default click handler
			$clickHandler = 'onclick';
		}

		// Parse the link
		$parsedUrl = parse_url($url);

		if (!$parsedUrl['host'])
		{
			// This doesn't appear to be an external URL
			return;
		}

		if (self::$config['dbtech_dbseo_analytics_universal'])
		{
			// Define the JS code to add
			$outLink = "ga('send', 'event', 'Outgoing', '" . addslashes($parsedUrl['host']) . "', '" . addslashes($parsedUrl['path'] . ($parsedUrl['query'] ? '?' . $parsedUrl['query'] : '')) . "');";
		}
		else
		{
			// Define the JS code to add
			$outLink = '_gaq.push([\'_trackEvent\', \'Outgoing\', \'' . addslashes($parsedUrl['host']) . '\', \'' . addslashes($parsedUrl['path'] . ($parsedUrl['query'] ? '?' . $parsedUrl['query'] : '')) . '\']);';
		}

		// Create a new suffix
		$urlSuffix2 = preg_replace('#(\sonclick=")(javascript\:)?#is', '\\1' . $outLink, $urlSuffix);
		
		if ($urlSuffix != $urlSuffix2)
		{
			// Set the suffix to the newly created one
			$urlSuffix = $urlSuffix2;
		}
		else
		{
			// Create a new prefix
			$urlPrefix2 = preg_replace('#(\sonclick=")(javascript\:)?#is', '\\1' . $outLink, $urlPrefix);
			
			// Set the prefix to the newly created one if need be
			$urlPrefix = $urlPrefix != $urlPrefix2 ? $urlPrefix2 : preg_replace('#(<a\s)#is', '\\1' . $clickHandler . '="' . $outLink . '" ', $urlPrefix);
		}
	}

	/*DBTECH_PRO_START*/
	/**
	 * Track spider hit
	 */
	public static function trackSpider($oldUrl = '')
	{
		if (!self::$config['dbtech_dbseo_enable_spiderlog'])
		{
			// We don't want logs around these parts
			return;
		}

		if ($oldUrl)
		{
			if (preg_match('#forumdisplay|showthread|member#', $script))
			{
				// We had a matching old script URL
				$script = '[old url - ' . $script . ']';
			}
			else
			{
				// Nothin to see here
				return;
			}
		}
		else
		{
			// Base script
			$script = substr($_SERVER['SCRIPT_NAME'], strstr(DBSEO_BASE, DBSEO_URL_SCRIPT_PATH) ? min(strlen(DBSEO_BASE), strlen(DBSEO_URL_SCRIPT_PATH)) : strlen(DBSEO_BASE));
			
			if (preg_match('#^(archive/index\.php)#', $script, $matches))
			{
				// This was the archive
				$script = $matches[1];
			}
			
			if (!self::$config['bbactive'])
			{
				// Forum was offline
				$script = '[forums-inactive]';
			}
		}

		if (preg_match('#[<>\/\?]#',$script))
		{
			// Unmatched script
			$script = 'other';
		}

		if (!$script)
		{
			// This must have been the home page
			$script = 'home';
		}

		// Create today's timestamp
		$date = mktime(0, 0, 0, date('n'), date('j'), date('Y'));

		// Update our bot info (spider)
		self::$db->modifyQuery('
			INSERT INTO $dbtech_dbseo_spiderlog
				(dateline, spider, script, hits)
			VALUES (
				' . $date . ',
				\'' . self::$db->escapeString(DBSEO_SPIDER) . '\',
				\'' . self::$db->escapeString($script) . '\',
				1
			)
			ON DUPLICATE KEY UPDATE hits = hits + 1
		');

		// Update our bot info (spider)
		self::$db->modifyQuery('
			INSERT INTO $dbtech_dbseo_spiderlog
				(dateline, spider, script, hits)
			VALUES (
				' . $date . ',
				\'' . self::$db->escapeString(DBSEO_SPIDER) . '\',
				\'all\',
				1
			)
			ON DUPLICATE KEY UPDATE hits = hits + 1
		');
		
		// Update our bot info (all)
		self::$db->modifyQuery('
			INSERT INTO $dbtech_dbseo_spiderlog
				(dateline, spider, script, hits)
			VALUES (
				' . $date . ',
				\'all\',
				\'' . self::$db->escapeString($script) . '\',
				1
			)
			ON DUPLICATE KEY UPDATE hits = hits + 1
		');
		
		// Update our bot info (all)
		self::$db->modifyQuery('
			INSERT INTO $dbtech_dbseo_spiderlog
				(dateline, spider, script, hits)
			VALUES (
				' . $date . ',
				\'all\',
				\'all\',
				1
			)
			ON DUPLICATE KEY UPDATE hits = hits + 1
		');
	}
	/*DBTECH_PRO_END*/
	
	/**
	* Class factory. This is used for instantiating the extended classes.
	*
	* @param	string			The type of the class to be called (user, forum etc.)
	* @param	vB_Registry		An instance of the vB_Registry object.
	* @param	integer			One of the ERRTYPE_x constants
	*
	* @return	vB_DataManager	An instance of the desired class
	*/
	public static function &initDataManager($classtype, &$registry, $errtype = ERRTYPE_STANDARD)
	{
		if (empty(self::$called))
		{
			// include the abstract base class
			require_once(DIR . '/includes/class_dm.php');
			self::$called = true;
		}
	
		if (preg_match('#^\w+$#', $classtype))
		{
			require_once(DIR . '/dbtech/dbseo/includes/class_dm_' . strtolower($classtype) . '.php');
	
			$classname = 'DBSEO_DataManager_' . $classtype;
			$object = new $classname($registry, $errtype);
	
			return $object;
		}
	}

	/**
	 * Check whether we have threaded mode
	 */
	public static function isThreaded()
	{
		global $vbulletin;

		// Default to user info
		$threadedMode = $vbulletin->userinfo['threadedmode'];
		
		if (!$vbulletin->userinfo['threadedmode'])
		{
			// Check the cookie
			$threadedMode = $_COOKIE[self::$config['_cookieprefix'] . 'threadedmode'];
		}

		if (isset(self::$config['allowthreadedmode']) AND !self::$config['allowthreadedmode'])
		{
			// We're not allowed to use threaded mode
			return false;
		}

		// Check the value
		return in_array($threadedMode, array('threaded', '1', '2', 'hybrid'));
	}

	/**
	 * Initialises the URL rewrite cache
	 */
	public static function subStr($str, $len)
	{
		//return preg_replace('#\s+\w+$#', '', (
		return (
			self::$config['dbtech_dbseo_enable_utf8'] ? 
				preg_replace('#^(?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,0}((?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,' . ($len + 1) . '}).*#s', '$1', $str) : 
				substr($str, 0, ($len + 1))
		);
		//));
	}

	/**
	 * Initialises the URL rewrite cache
	 */
	public static function initUrlCache()
	{
		switch (self::$config['dbtech_dbseo_filter_nonlatin_chars'])
		{
			case 0:
				$chars = '\S';
				$set = '[^/]';
				break;

			case 1:
				$chars = 'a-z\._';
				$set = '[' . $chars . 'A-Z\d-]';
				break;

			default:
				$chars = 'a-z\._\\' . self::$config['dbtech_dbseo_rewrite_separator'] . '';
				$set = '[' . $chars . 'A-Z\d-]';
				break;
		}

		$replace = array(
			'#%attachment_id%#' 		=> '([dt\d]+)',
			'#%picture_id%#' 			=> '([dt\d]+)',
			'#%[a-z_]+_id%#' 			=> '(\d+)',
			'#%year%#' 					=> '(\d+)',
			'#%month%#' 				=> '(\d+)',
			'#%day%#' 					=> '(\d+)',
			'#%[a-z_]+_path%#' 			=> '([' . $chars . 'A-Z\d/-]+)',
			'#%[a-z_]+_filename%#' 		=> '(.+)',
			'#%tag%#' 					=> '(.+)',
			'#%(album|group)_title%#' 	=> '([^/]+)',
			'#%[a-z_]+_name%#' 			=> '([^/]+)',
			'#%[a-z_]+_title%#' 		=> '(' . $set . '+)',
			'#%[a-z_]+_ext%#' 			=> '([^/]+)', 
			'#%post_count%#' 			=> '(\d*?)',
			'#%letter%#' 				=> '([a-z]|0|all)',
			'#%[a-z_]*page%#' 			=> '(\d+)',
			'#%[a-z_]+%#' 				=> '(' . $set . ')+',
		);

		if (self::$config['dbtech_dbseo_rewrite_rule_forumpath'] == 'custom')
		{
			// Override forum path with the custom string
			self::$config['dbtech_dbseo_rewrite_rule_forumpath'] = str_replace(array('[', ']'), '%', self::$config['dbtech_dbseo_rewrite_rule_forumpath_custom']);
		}
	
		foreach (self::$libraries as $optionGroup => $options)
		{
			// Shorthand
			$optionGroup = strtolower($optionGroup);

			foreach ($options as $option => $optionInfo)
			{
				// Ensure this is properly set
				$optionKey = 'dbtech_dbseo_rewrite_rule_' . strtolower($option);

				// By default, assume actual value
				$optionValue = self::$config[$optionKey];

				if ($optionValue == 'custom')
				{
					// We need to do some replacement trickery for custom ones
					$optionValue = str_replace(array('[', ']'), '%', self::$config[$optionKey . '_custom']);
				}

				// Store the raw URLs
				self::$cache['rawurls'][$optionGroup][$option] = $optionValue;

				// Store the prepared URLs
				self::$cache['preparedurls'][$optionGroup][$option] = preg_replace(array_keys($replace), $replace, preg_quote($optionValue, '#'));
			}
		}

		/*DBTECH_PRO_START*/
		$customRedirects = preg_split('#\r?\n#s', self::$config['dbtech_dbseo_customredirect'], -1, PREG_SPLIT_NO_EMPTY);
		foreach ($customRedirects as $key => $val)
		{
			$pos = strpos($val, '//');
			if ($pos !== false AND $pos == 0)
			{
				// Skip this, it was disabled
				continue;
			}

			// Ensure we split this properly
			$val = preg_split('#\s*=>\s*#s', $val, -1, PREG_SPLIT_NO_EMPTY);

			$val[0] = substr($val[0], 1, -1);
			$val[1] = substr($val[1], 1, -1);

			// Store the raw URLs
			self::$cache['rawurls']['customredirect']['#' . str_replace(array('#', '&'), array('\#', '&(?:amp;)?'), $val[0]) . '#'] = str_replace('[NF]', '', $val[1]);
		}

		$customRules = preg_split('#\r?\n#s', self::$config['dbtech_dbseo_customrewrite'], -1, PREG_SPLIT_NO_EMPTY);
		foreach ($customRules as $key => $val)
		{
			$pos = strpos($val, '//');
			if ($pos !== false AND $pos == 0)
			{
				// Skip this, it was disabled
				continue;
			}

			// Ensure we split this properly
			$val = preg_split('#\s*=>\s*#s', $val, -1, PREG_SPLIT_NO_EMPTY);

			$val[0] = substr($val[0], 1, -1);
			$val[1] = substr($val[1], 1, -1);

			// Store the raw URLs
			self::$cache['rawurls']['custom']['#' . str_replace(array('#', '&'), array('\#', '&(?:amp;)?'), $val[0]) . '#'] = $val[1];

			if (substr($val[1], 0, 1) == '/')
			{
				// Get rid of starting dir mark
				$val[1] = substr($val[1], 1);
			}

			// Get rid of this
			$val[1] = str_replace('[NF]', '', $val[1]);
			
			// Store the matches we need
			preg_match_all('#\$(\d+)#', $val[1], $numberMatches);
			preg_match_all('#\(.*?\)#', $val[0], $otherMatches);
			
			// Replace the other matches
			// @TODO: Eval fix
			$val[1] = preg_replace('#\$(\d+)#ei', '$otherMatches[0][\\1-1]', str_replace('\$', '$', preg_quote($val[1], '#')));
	
			$i = 0;
			
			// First get rid of a bunch of slashes
			$val[0] = preg_replace('#[^\\\\\]\)]\?#', 	'', $val[0]);

			// Do number replacements
			// @TODO: Eval fix
			$val[0] = preg_replace('#\(.*?\)#ei', 		'"$" . (array_search(++$i, $numberMatches[1]) + 1)', stripslashes($val[0]));

			// Then do the last 2 replacements
			$val[0] = preg_replace(array('#\$\d+\?#', '#.[\*\+]\??#'), '', $val[0]);
			
			if ($val[0][0] == '^')
			{
				// We started with a ^
				$val[1] = '^' . $val[1];
				$val[0] = substr($val[0], 1);
			}

			$suffix = '';
			if (substr($val[0], 0, -1) == '$')
			{
				// We need to suffix our EOL
				$suffix = '$';
				$val[0] = substr($val[0], 0, strlen($val[0]) - 1);
			}

			// Store the URL with suffix in the pattern
			self::$cache['preparedurls']['custom'][0]['#' . $val[1] . $suffix . '#'] = substr($val[0], 0, -1);

			if (substr($val[1], -1) == '/')
			{
				// Allow for URL params
				$val[1] .= '?';
				$val[0] .= '#s#';
			}

			// Suffix the, well, suffix
			$val[1] .= $suffix;

			// Store the URL with the suffix in the rule
			self::$cache['preparedurls']['custom'][1]['#' . $val[1] . '#'] = $val[0];
		}
		/*DBTECH_PRO_END*/
	}

	/**
	 * Fetches a value from $_SERVER or $_ENV
	 *
	 * @param string $name
	 * @return string
	 */
	private static function fetchServerValue($name)
	{
		if (isset($_SERVER[$name]) AND $_SERVER[$name])
		{
			return $_SERVER[$name];
		}

		if (isset($_ENV[$name]) AND $_ENV[$name])
		{
			return $_ENV[$name];
		}

		return false;
	}

	private static function urlencodeQuery($url)
	{
		$useragent = strtolower($_SERVER['HTTP_USER_AGENT']);
		if (strpos($useragent, 'opera') !== false)
		{
			preg_match('#opera(/| )([0-9\.]+)#', $useragent, $regs);
			$isopera = $regs[2];
		}
		if (strpos($useragent, 'msie ') !== false AND !$isopera)
		{
			preg_match('#msie ([0-9\.]+)#', $useragent, $regs);
			$isie = $regs[1];
		}
		if (!$isie)
		{
			return $url;
		}

		$querystring = array();
		$bits = explode('?', $url);
		if ($bits[1])
		{
			$bits[1] = urldecode($bits[1]);
			$subbits = explode('&', $bits[1]);
			foreach ($subbits AS $querypart)
			{
				$querybit = explode('=', $querypart);
				if ($querybit[1])
				{
					$querystring[] = urlencode($querybit[0]) . '=' . urlencode($querybit[1]);
				}
				else
				{
					$querystring[] = urlencode($querybit[0]);
				}
			}
			return $bits[0] . '?' . implode('&', $querystring);
		}
		return $url;
	}

	/**
	*	Workaround for a UTF8 compatible parse_url
	*/

	private static function parseUrl($url, $component = -1)
	{
		// Taken from /rfc3986#section-2
		$safechars =array(':', '/', '?', '#', '[', ']', '@', '!', '$', '&', '\'' ,'(', ')', '*', '+', ',', ';', '=');
		$trans = array('%3A', '%2F', '%3F', '%23', '%5B', '%5D', '%40', '%21', '%24', '%26', '%27', '%28', '%29', '%2A', '%2B', '%2C', '%3B', '%3D');
		$encodedurl = str_replace($trans, $safechars, urlencode($url));

		$parsed = @parse_url($encodedurl, $component);
		if (is_array($parsed))
		{
			foreach ($parsed AS $index => $element)
			{
				$parsed[$index] = urldecode($element);
			}
		}
		else
		{
			$parsed = urldecode($parsed);
		}

		return $parsed;
	}

	/**
	* Removes HTML characters and potentially unsafe scripting words from a string
	*
	* @param	string	The variable we want to make safe
	*
	* @return	string
	*/
	private static function xssClean($var)
	{
		static
			$preg_find= array('#^javascript#i', '#^vbscript#i'),
			$preg_replace = array('java script',   'vb script');

		return preg_replace($preg_find, $preg_replace, htmlspecialchars(trim($var)));
	}


	/**
	* Strips out the s=gobbledygook& rubbish from URLs
	*
	* @param	string	The URL string from which to remove the session stuff
	*
	* @return	string
	*/
	private static function stripSessionhash($string)
	{
		$string = preg_replace('/(s|sessionhash)=[a-z0-9]{32}?&?/', '', $string);
		return $string;
	}

	/**
	 * Adds a query string to a path, fixing the query characters.
	 *
	 * @param 	string		The path to add the query to
	 * @param 	string		The query string to add to the path
	 *
	 * @return	string		The resulting string
	 */
	private static function addQuery($path, $query = false)
	{
		if (false === $query)
		{
			$query = DBSEO_URL_QUERY;
		}

		if (!$query OR !($query = trim($query, '?&')))
		{
			return $path;
		}

		return $path . '?' . $query;
	}

	/**
	 * Converts a string from one character encoding to another.
	 * If the target encoding is not specified then it will be resolved from the current
	 * language settings.
	 *
	 * @param	string	The string to convert
	 * @param	string	The source encoding
	 * @return	string	The target encoding
	 */
	private static function _toCharset($in, $in_encoding, $target_encoding = false)
	{
		if (!$target_encoding)
		{
			global $stylevar;
			if (!($target_encoding = $stylevar['charset']))
			{
				global $vbulletin;
				if (!($target_encoding = $vbulletin->userinfo['lang_charset']))
				{
					return $in;
				}
			}
		}

		// Try iconv
		if (function_exists('iconv') AND $out = @iconv($in_encoding, $target_encoding, $in))
		{
			return $out;
		}

		// Try mbstring
		if (function_exists('mb_convert_encoding') AND $out = @mb_convert_encoding($in, $target_encoding, $in_encoding))
		{
			return $out;
		}

		return $in;
	}
}